/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.v2.XCapability;
import org.jboss.osgi.resolver.v2.XRequirement;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.XResourceBuilder;
import org.jboss.osgi.resolver.v2.spi.AbstractCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractHostCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractHostRequirement;
import org.jboss.osgi.resolver.v2.spi.AbstractIdentityCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractIdentityRequirement;
import org.jboss.osgi.resolver.v2.spi.AbstractPackageCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractPackageRequirement;
import org.jboss.osgi.resolver.v2.spi.AbstractRequirement;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.resource.Resource;

public class AbstractResourceBuilder
extends XResourceBuilder {
    public AbstractResourceBuilder(XResource resource) {
        super(resource);
    }

    public AbstractResourceBuilder() {
    }

    @Override
    public XCapability addIdentityCapability(String symbolicName, Version version, String type, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.identity", symbolicName);
        atts.put("version", version);
        atts.put("type", type != null ? type : "unknown");
        AbstractIdentityCapability cap = new AbstractIdentityCapability(this.resource, atts, dirs);
        this.resource.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addIdentityRequirement(String symbolicName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.identity", symbolicName);
        AbstractIdentityRequirement req = new AbstractIdentityRequirement(this.resource, atts, dirs);
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XCapability addHostCapability(String symbolicName, Version version, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.host", symbolicName);
        atts.put("bundle-version", version);
        AbstractHostCapability cap = new AbstractHostCapability(this.resource, atts, dirs);
        this.resource.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addHostRequirement(String symbolicName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.host", symbolicName);
        AbstractHostRequirement req = new AbstractHostRequirement(this.resource, atts, dirs);
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XCapability addPackageCapability(String packageName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.package", packageName);
        AbstractPackageCapability cap = new AbstractPackageCapability(this.resource, atts, dirs);
        this.resource.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addPackageRequirement(String packageName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.package", packageName);
        AbstractPackageRequirement req = new AbstractPackageRequirement((Resource)this.resource, atts, dirs, false);
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XRequirement addDynamicPackageRequirement(String packageName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.package", packageName);
        dirs.put("resolution", "optional");
        AbstractPackageRequirement req = new AbstractPackageRequirement((Resource)this.resource, atts, dirs, true);
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XCapability addGenericCapability(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        AbstractCapability cap = "osgi.identity".equals(namespace) ? new AbstractIdentityCapability(this.resource, atts, dirs) : ("osgi.wiring.package".equals(namespace) ? new AbstractPackageCapability(this.resource, atts, dirs) : ("osgi.wiring.host".equals(namespace) ? new AbstractHostCapability(this.resource, atts, dirs) : new AbstractCapability(this.resource, namespace, atts, dirs)));
        this.resource.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addGenericRequirement(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        AbstractRequirement req;
        this.assertResourceCreated();
        if ("osgi.identity".equals(namespace)) {
            req = new AbstractIdentityRequirement(this.resource, atts, dirs);
        } else if ("osgi.wiring.package".equals(namespace)) {
            String packageName = (String)atts.get(namespace);
            req = new AbstractPackageRequirement((Resource)this.resource, atts, dirs, packageName.endsWith("*"));
        } else {
            req = "osgi.wiring.host".equals(namespace) ? new AbstractHostRequirement(this.resource, atts, dirs) : new AbstractRequirement(this.resource, namespace, atts, dirs);
        }
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XResourceBuilder load(OSGiMetaData metadata) throws BundleException {
        this.assertResourceCreated();
        try {
            List dynamicImports;
            List imports;
            List exports;
            String symbolicName = metadata.getBundleSymbolicName();
            Version bundleVersion = metadata.getBundleVersion();
            ParameterizedAttribute idparams = metadata.getBundleParameters();
            Map<String, Object> idatts = this.getAttributes(idparams);
            Map<String, String> iddirs = this.getDirectives(idparams);
            ParameterizedAttribute fragmentHost = metadata.getFragmentHost();
            String identityType = fragmentHost != null ? "osgi.fragment" : "osgi.bundle";
            this.addIdentityCapability(symbolicName, bundleVersion, identityType, idatts, iddirs);
            if (fragmentHost != null) {
                String hostName = fragmentHost.getAttribute();
                Map<String, Object> atts = this.getAttributes(fragmentHost);
                Map<String, String> dirs = this.getDirectives(fragmentHost);
                this.addHostRequirement(hostName, atts, dirs);
            } else if (!"system.bundle".equals(symbolicName)) {
                Map<String, Object> atts = this.getAttributes(idparams);
                Map<String, String> dirs = this.getDirectives(idparams);
                this.addHostCapability(symbolicName, bundleVersion, atts, dirs);
            }
            List requireBundles = metadata.getRequireBundles();
            if (requireBundles != null && !requireBundles.isEmpty()) {
                for (ParameterizedAttribute attr : requireBundles) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts = this.getAttributes(attr);
                    Map<String, String> dirs = this.getDirectives(attr);
                    this.addIdentityRequirement(name, atts, dirs);
                }
            }
            if ((exports = metadata.getExportPackages()) != null && !exports.isEmpty()) {
                for (PackageAttribute attr : exports) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts = this.getAttributes((ParameterizedAttribute)attr);
                    Map<String, String> dirs = this.getDirectives((ParameterizedAttribute)attr);
                    this.addPackageCapability(name, atts, dirs);
                }
            }
            if ((imports = metadata.getImportPackages()) != null && !imports.isEmpty()) {
                for (PackageAttribute attr : imports) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts = this.getAttributes((ParameterizedAttribute)attr);
                    Map<String, String> dirs = this.getDirectives((ParameterizedAttribute)attr);
                    this.addPackageRequirement(name, atts, dirs);
                }
            }
            if ((dynamicImports = metadata.getDynamicImports()) != null && !dynamicImports.isEmpty()) {
                for (PackageAttribute attr : dynamicImports) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts = this.getAttributes((ParameterizedAttribute)attr);
                    Map<String, String> dirs = this.getDirectives((ParameterizedAttribute)attr);
                    this.addDynamicPackageRequirement(name, atts, dirs);
                }
            }
        }
        catch (RuntimeException ex) {
            throw new BundleException("Cannot initialize XResource from: " + metadata, (Throwable)ex);
        }
        return this;
    }

    private Map<String, String> getDirectives(ParameterizedAttribute patts) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        if (patts != null) {
            for (String key : patts.getDirectives().keySet()) {
                String value = (String)patts.getDirectiveValue(key, String.class);
                dirs.put(key.trim(), value.trim());
            }
        }
        return dirs;
    }

    private Map<String, Object> getAttributes(ParameterizedAttribute patts) {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        if (patts != null) {
            for (String key : patts.getAttributes().keySet()) {
                Parameter param = patts.getAttribute(key);
                atts.put(key.trim(), param.getValue().toString().trim());
            }
        }
        return atts;
    }

    private void assertResourceCreated() {
        if (this.resource == null) {
            throw new IllegalStateException("Resource not created");
        }
    }
}

