/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleProtocolHandler;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.OSGiContentHandlerFactory;
import org.jboss.osgi.framework.internal.OSGiContentHandlerFactoryDelegate;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactory;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactoryDelegate;
import org.jboss.osgi.framework.internal.OSGiStreamHandlerFactoryService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;
import org.osgi.util.tracker.ServiceTracker;

final class URLHandlerPlugin
extends AbstractPluginService<URLHandlerPlugin>
implements URLStreamHandlerFactory,
ContentHandlerFactory {
    private static final Logger log = Logger.getLogger(URLHandlerPlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private ServiceTracker streamServiceTracker;
    private ServiceTracker contentServiceTracker;
    private ServiceRegistration registration;
    private static OSGiContentHandlerFactoryDelegate contentHandlerDelegate;
    private static OSGiStreamHandlerFactoryDelegate streamHandlerDelegate;

    static void addService(ServiceTarget serviceTarget) {
        URLHandlerPlugin service = new URLHandlerPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.URL_HANDLER_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private URLHandlerPlugin() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        OSGiStreamHandlerFactoryService.setDelegateFactory(this);
        streamHandlerDelegate.setDelegateFactory(new OSGiStreamHandlerFactory(this));
        contentHandlerDelegate.setDelegateFactory(new OSGiContentHandlerFactory(this));
        this.registerStreamHandlerService();
        this.setupStreamHandlerTracker();
        this.setupContentHandlerTracker();
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        streamHandlerDelegate.clearHandlers();
        contentHandlerDelegate.clearHandlers();
        this.registration.unregister();
        streamHandlerDelegate.setDelegateFactory(null);
        contentHandlerDelegate.setDelegateFactory(null);
        OSGiStreamHandlerFactoryService.setDelegateFactory(null);
    }

    public URLHandlerPlugin getValue() {
        return this;
    }

    private void registerStreamHandlerService() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", "bundle");
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        BundleProtocolHandler service = new BundleProtocolHandler(bundleManager);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = systemContext.registerService(URLStreamHandlerService.class.getName(), (Object)service, props);
    }

    private void setupContentHandlerTracker() {
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.contentServiceTracker = new ServiceTracker(systemContext, ContentHandler.class.getName(), null){

            @Override
            public Object addingService(ServiceReference reference) {
                Object svc = super.addingService(reference);
                Object[] mimeTypes = URLHandlerPlugin.this.parseServiceProperty(reference.getProperty("url.content.mimetype"));
                if (mimeTypes != null && svc instanceof ContentHandler) {
                    for (Object mimeType : mimeTypes) {
                        contentHandlerDelegate.addHandler((String)mimeType, reference);
                    }
                } else {
                    log.errorf("A non-compliant instance of %s has been registered for mime types %s for %s", (Object)ContentHandler.class.getName(), (Object)Arrays.toString(mimeTypes), svc);
                }
                return svc;
            }

            @Override
            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            @Override
            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                contentHandlerDelegate.removeHandler(reference);
            }
        };
        this.contentServiceTracker.open();
    }

    private void setupStreamHandlerTracker() {
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.streamServiceTracker = new ServiceTracker(systemContext, URLStreamHandlerService.class.getName(), null){

            @Override
            public Object addingService(ServiceReference reference) {
                Object svc = super.addingService(reference);
                String[] protocols = URLHandlerPlugin.this.parseServiceProperty(reference.getProperty("url.handler.protocol"));
                if (protocols != null && svc instanceof URLStreamHandlerService) {
                    for (String protocol : protocols) {
                        streamHandlerDelegate.addHandler(protocol, reference);
                    }
                } else {
                    log.errorf("A non-compliant instance of %s has been registered for protocols %s for: %s", (Object)URLStreamHandlerService.class.getName(), Arrays.asList(protocols), svc);
                }
                return svc;
            }

            @Override
            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            @Override
            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                streamHandlerDelegate.removeHandler(reference);
            }
        };
        this.streamServiceTracker.open();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        List<ServiceReference> refList = streamHandlerDelegate.getStreamHandlers(protocol);
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        return new URLStreamHandlerProxy(protocol, refList);
    }

    @Override
    public ContentHandler createContentHandler(String mimetype) {
        List<ServiceReference> refList = contentHandlerDelegate.getContentHandlers(mimetype);
        if (refList == null || refList.isEmpty()) {
            return null;
        }
        ServiceReference ref = refList.get(0);
        Object service = ref.getBundle().getBundleContext().getService(ref);
        if (service instanceof ContentHandler) {
            return (ContentHandler)service;
        }
        return null;
    }

    private String[] parseServiceProperty(Object prop) {
        if (prop == null) {
            return null;
        }
        if (prop instanceof String) {
            return new String[]{(String)prop};
        }
        if (prop instanceof String[]) {
            return (String[])prop;
        }
        return null;
    }

    static {
        streamHandlerDelegate = new OSGiStreamHandlerFactoryDelegate();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    URL.setURLStreamHandlerFactory(streamHandlerDelegate);
                }
                catch (Throwable th) {
                    log.debugf("Unable to set the URLStreamHandlerFactory", new Object[0]);
                }
                return null;
            }
        });
        contentHandlerDelegate = new OSGiContentHandlerFactoryDelegate();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    URLConnection.setContentHandlerFactory(contentHandlerDelegate);
                }
                catch (Throwable th) {
                    log.debugf("Unable to set the ContentHandlerFactory", new Object[0]);
                }
                return null;
            }
        });
    }

    private static final class URLStreamHandlerProxy
    extends URLStreamHandler
    implements URLStreamHandlerSetter {
        private final List<ServiceReference> serviceReferences;
        private final String protocol;

        public URLStreamHandlerProxy(String protocol, List<ServiceReference> refList) {
            this.protocol = protocol;
            this.serviceReferences = refList;
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
            super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
        }

        @Override
        public void setURL(URL u, String protocol, String host, int port, String file, String ref) {
            super.setURL(u, protocol, host, port, file, ref);
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            this.getHandlerService().parseURL((URLStreamHandlerSetter)this, u, spec, start, limit);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return this.getHandlerService().openConnection(u);
        }

        @Override
        protected String toExternalForm(URL u) {
            return this.getHandlerService().toExternalForm(u);
        }

        @Override
        protected URLConnection openConnection(URL u, Proxy p) throws IOException {
            URLStreamHandlerService handler = this.getHandlerService();
            try {
                Method method = handler.getClass().getDeclaredMethod("openConnection", URL.class, Proxy.class);
                return (URLConnection)method.invoke((Object)handler, u, p);
            }
            catch (NoSuchMethodException e) {
                throw new IOException("openConnection(URL,Proxy) not found on " + handler, e);
            }
            catch (IllegalAccessException e) {
                throw new IOException("openConnection(URL,Proxy) not accessible on " + handler, e);
            }
            catch (InvocationTargetException e) {
                throw new IOException("Problem invoking openConnection(URL,Proxy) on " + handler, e);
            }
        }

        @Override
        protected int getDefaultPort() {
            return this.getHandlerService().getDefaultPort();
        }

        @Override
        protected boolean equals(URL u1, URL u2) {
            return this.getHandlerService().equals(u1, u2);
        }

        @Override
        protected int hashCode(URL u) {
            return this.getHandlerService().hashCode(u);
        }

        @Override
        protected boolean sameFile(URL u1, URL u2) {
            return this.getHandlerService().sameFile(u1, u2);
        }

        @Override
        protected synchronized InetAddress getHostAddress(URL u) {
            return this.getHandlerService().getHostAddress(u);
        }

        @Override
        protected boolean hostsEqual(URL u1, URL u2) {
            return this.getHandlerService().hostsEqual(u1, u2);
        }

        private URLStreamHandlerService getHandlerService() {
            if (this.serviceReferences.isEmpty()) {
                throw new IllegalStateException("No handlers in the OSGi Service registry for protocol: " + this.protocol);
            }
            ServiceReference ref = this.serviceReferences.get(0);
            Object service = ref.getBundle().getBundleContext().getService(ref);
            if (service instanceof URLStreamHandlerService) {
                return (URLStreamHandlerService)service;
            }
            throw new IllegalStateException("Problem with OSGi URL handler service " + service + " for url:" + this.protocol);
        }
    }
}

