/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemPathsProvider;
import org.jboss.osgi.framework.internal.AbstractBundleService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XModule;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class SystemBundleService
extends AbstractBundleService<SystemBundleState> {
    static final Logger log = Logger.getLogger(SystemBundleService.class);
    private final InjectedValue<SystemPathsProvider> injectedSystemPaths = new InjectedValue();
    private final InjectedValue<FrameworkModuleProvider> injectedModuleProvider = new InjectedValue();
    private final InjectedValue<BundleStoragePlugin> injectedBundleStorage = new InjectedValue();
    private final InjectedValue<ResolverPlugin> injectedResolverPlugin = new InjectedValue();
    private SystemBundleState bundleState;

    static void addService(ServiceTarget serviceTarget, FrameworkState frameworkState) {
        SystemBundleService service = new SystemBundleService(frameworkState);
        ServiceBuilder builder = serviceTarget.addService(Services.SYSTEM_BUNDLE, (Service)service);
        builder.addDependency(Services.FRAMEWORK_MODULE_PROVIDER, FrameworkModuleProvider.class, service.injectedModuleProvider);
        builder.addDependency(Services.SYSTEM_PATHS_PROVIDER, SystemPathsProvider.class, service.injectedSystemPaths);
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, service.injectedBundleStorage);
        builder.addDependency(InternalServices.RESOLVER_PLUGIN, ResolverPlugin.class, service.injectedResolverPlugin);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private SystemBundleService(FrameworkState frameworkState) {
        super(frameworkState);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            this.bundleState = this.createBundleState();
            this.bundleState.changeState(8);
            OSGiMetaData metadata = this.createOSGiMetaData();
            XModule resModule = this.bundleState.createResolverModule(metadata);
            this.bundleState.createBundleRevision(metadata, resModule);
            this.bundleState.createBundleContext();
            this.bundleState.createStorageState((BundleStoragePlugin)((Object)this.injectedBundleStorage.getValue()));
            ((ResolverPlugin)((Object)this.injectedResolverPlugin.getValue())).addModule(resModule);
            BundleManager bundleManager = this.getBundleManager();
            bundleManager.injectedSystemBundle.inject((Object)this.bundleState);
            bundleManager.addBundle(this.bundleState);
        }
        catch (BundleException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    SystemBundleState createBundleState() {
        return new SystemBundleState(this.getFrameworkState(), (FrameworkModuleProvider)this.injectedModuleProvider.getValue());
    }

    @Override
    SystemBundleState getBundleState() {
        return this.bundleState;
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        BundleManager bundleManager = this.getBundleManager();
        bundleManager.injectedSystemBundle.uninject();
    }

    private OSGiMetaData createOSGiMetaData() {
        SystemBundleState bundleState = this.getBundleState();
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)bundleState.getSymbolicName(), (Version)bundleState.getVersion());
        SystemPathsProvider systemPackages = (SystemPathsProvider)this.injectedSystemPaths.getValue();
        ArrayList<String> exportedPackages = new ArrayList<String>();
        exportedPackages.addAll(systemPackages.getSystemPackages());
        if (exportedPackages.isEmpty()) {
            throw new IllegalStateException("Framework system packages not available");
        }
        Iterator i$ = exportedPackages.iterator();
        while (i$.hasNext()) {
            String packageSpec;
            String packname = packageSpec = (String)i$.next();
            Version version = Version.emptyVersion;
            int versionIndex = packname.indexOf(";version=");
            if (versionIndex > 0) {
                packname = packageSpec.substring(0, versionIndex);
                version = Version.parseVersion((String)packageSpec.substring(versionIndex + 9));
            }
            builder.addExportPackages(new String[]{packname + ";version=" + version});
        }
        return builder.getOSGiMetaData();
    }
}

