/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.http.server.security.DigestAuthenticator;
import org.jboss.as.domain.http.server.security.NonceFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;

class LogoutHandler
implements ManagementHttpHandler {
    private NonceFactory nonceFactory = new NonceFactory();
    private String realm;

    LogoutHandler() {
    }

    @Override
    public void start(HttpServer httpServer, SecurityRealm securityRealm) {
        httpServer.createContext("/logout", (HttpHandler)this);
        this.realm = securityRealm != null ? securityRealm.getName() : null;
    }

    @Override
    public void stop(HttpServer httpServer) {
        httpServer.removeContext("/logout");
    }

    public void handle(HttpExchange exchange) throws IOException {
        Headers requestHeaders = exchange.getRequestHeaders();
        Headers responseHeaders = exchange.getResponseHeaders();
        if (this.realm == null) {
            responseHeaders.set("Location", "/");
            exchange.sendResponseHeaders(307, -1L);
        }
        String authorization = requestHeaders.getFirst("Authorization");
        String rawQuery = exchange.getRequestURI().getRawQuery();
        boolean query = rawQuery != null && rawQuery.contains("logout");
        String userAgent = requestHeaders.getFirst("User-Agent");
        boolean opera = userAgent != null && userAgent.contains("Opera");
        boolean win = !opera && userAgent != null && userAgent.contains("MSIE");
        String referrer = responseHeaders.getFirst("Referrer");
        String protocol = "http";
        String host = null;
        if (referrer != null) {
            try {
                URI uri = new URI(referrer);
                protocol = uri.getScheme();
                host = uri.getHost() + (uri.getPort() == -1 ? "" : ":" + String.valueOf(uri.getPort()));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (host == null && (host = requestHeaders.getFirst("Host")) == null) {
            exchange.sendResponseHeaders(500, -1L);
            return;
        }
        if (!(win || authorization != null && authorization.contains("enter-login-here"))) {
            if (!query) {
                responseHeaders.set("Location", protocol + "://enter-login-here:blah@" + host + "/logout?logout");
                exchange.sendResponseHeaders(307, -1L);
                return;
            }
            String realm = opera ? "HIT THE ESCAPE KEY" : this.realm;
            DigestAuthenticator.DigestContext context = DigestAuthenticator.getOrCreateNegotiationContext(exchange, this.nonceFactory, false);
            responseHeaders.add("WWW-Authenticate", "Digest " + DigestAuthenticator.createChallenge(context, realm, false));
            exchange.sendResponseHeaders(401, 0L);
            PrintStream print = new PrintStream(exchange.getResponseBody());
            print.println("<html><script type='text/javascript'>window.location=\"" + protocol + "://" + host + "/\";</script></html>");
            print.flush();
            print.close();
            return;
        }
        responseHeaders.set("Location", protocol + "://" + host + "/");
        exchange.sendResponseHeaders(307, -1L);
    }
}

