/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RootPlatformMBeanResource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.RuntimeExpressionResolver;
import org.jboss.as.server.ServerControllerModelUtil;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentResourceDescription;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.ServiceLoaderProcessor;
import org.jboss.as.server.deployment.SubDeploymentProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndexProcessor;
import org.jboss.as.server.deployment.integration.Seam2Processor;
import org.jboss.as.server.deployment.module.ClassFileTransformerProcessor;
import org.jboss.as.server.deployment.module.DeploymentRootExplodedMountProcessor;
import org.jboss.as.server.deployment.module.DeploymentRootMountProcessor;
import org.jboss.as.server.deployment.module.DeploymentVisibilityProcessor;
import org.jboss.as.server.deployment.module.DriverDependenciesProcessor;
import org.jboss.as.server.deployment.module.ManifestAttachmentProcessor;
import org.jboss.as.server.deployment.module.ManifestClassPathProcessor;
import org.jboss.as.server.deployment.module.ManifestDependencyProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionListProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleClassPathProcessor;
import org.jboss.as.server.deployment.module.ModuleDependencyProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionListProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleIdentifierProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecProcessor;
import org.jboss.as.server.deployment.module.ServerDependenciesProcessor;
import org.jboss.as.server.deployment.module.SubDeploymentDependencyProcessor;
import org.jboss.as.server.deployment.module.descriptor.DeploymentStructureDescriptorParser;
import org.jboss.as.server.deployment.reflect.InstallReflectionIndexProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorDependencyProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorProcessor;
import org.jboss.as.server.mgmt.domain.RemoteFileRepository;
import org.jboss.as.server.moduleservice.ExtensionIndexService;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;

public final class ServerService
extends AbstractControllerService {
    private final InjectedValue<DeploymentMountProvider> injectedDeploymentRepository = new InjectedValue();
    private final InjectedValue<ContentRepository> injectedContentRepository = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> injectedModuleLoader = new InjectedValue();
    private final InjectedValue<ExternalModuleService> injectedExternalModuleService = new InjectedValue();
    private final Bootstrap.Configuration configuration;
    private final BootstrapListener bootstrapListener;
    private final ControlledProcessState processState;
    private final RunningModeControl runningModeControl;
    private volatile ExecutorService queuelessExecutor;
    private volatile ExtensibleConfigurationPersister extensibleConfigurationPersister;
    private final AbstractVaultReader vaultReader;
    private final RemoteFileRepository remoteFileRepository;

    ServerService(Bootstrap.Configuration configuration, ControlledProcessState processState, OperationStepHandler prepareStep, BootstrapListener bootstrapListener, RunningModeControl runningModeControl, AbstractVaultReader vaultReader, RemoteFileRepository remoteFileRepository) {
        super(ServerService.getProcessType(configuration.getServerEnvironment()), runningModeControl, null, processState, ServerDescriptionProviders.ROOT_PROVIDER, prepareStep, (ExpressionResolver)new RuntimeExpressionResolver(vaultReader));
        this.configuration = configuration;
        this.bootstrapListener = bootstrapListener;
        this.processState = processState;
        this.runningModeControl = runningModeControl;
        this.vaultReader = vaultReader;
        this.remoteFileRepository = remoteFileRepository;
    }

    static ProcessType getProcessType(ServerEnvironment serverEnvironment) {
        if (serverEnvironment != null) {
            switch (serverEnvironment.getLaunchType()) {
                case DOMAIN: {
                    return ProcessType.DOMAIN_SERVER;
                }
                case STANDALONE: {
                    return ProcessType.STANDALONE_SERVER;
                }
                case EMBEDDED: {
                    return ProcessType.EMBEDDED_SERVER;
                }
                case APPCLIENT: {
                    return ProcessType.APPLICATION_CLIENT;
                }
            }
        }
        return ProcessType.EMBEDDED_SERVER;
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration, ControlledProcessState processState, BootstrapListener bootstrapListener, RunningModeControl runningModeControl, AbstractVaultReader vaultReader, RemoteFileRepository remoteFileRepository) {
        ServerService service = new ServerService(configuration, processState, null, bootstrapListener, runningModeControl, vaultReader, remoteFileRepository);
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVER_CONTROLLER, (Service)service);
        serviceBuilder.addDependency(DeploymentMountProvider.SERVICE_NAME, DeploymentMountProvider.class, service.injectedDeploymentRepository);
        serviceBuilder.addDependency(ContentRepository.SERVICE_NAME, ContentRepository.class, service.injectedContentRepository);
        serviceBuilder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.injectedModuleLoader);
        serviceBuilder.addDependency(Services.JBOSS_EXTERNAL_MODULE_SERVICE, ExternalModuleService.class, service.injectedExternalModuleService);
        serviceBuilder.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        ServerEnvironment serverEnvironment = this.configuration.getServerEnvironment();
        this.initializeExecutorService(serverEnvironment);
        Bootstrap.ConfigurationPersisterFactory configurationPersisterFactory = this.configuration.getConfigurationPersisterFactory();
        this.extensibleConfigurationPersister = configurationPersisterFactory.createConfigurationPersister(serverEnvironment, (ExecutorService)this.getExecutorServiceInjector().getOptionalValue());
        this.setConfigurationPersister((ConfigurationPersister)this.extensibleConfigurationPersister);
        super.start(context);
    }

    private void initializeExecutorService(ServerEnvironment serverEnvironment) {
        if (serverEnvironment.isAllowModelControllerExecutor()) {
            ThreadGroup threadGroup = new ThreadGroup("ModelController ThreadGroup");
            String namePattern = "ServerService Thread Pool -- %t";
            JBossThreadFactory threadFactory = new JBossThreadFactory(threadGroup, Boolean.FALSE, null, "ServerService Thread Pool -- %t", null, null, AccessController.getContext());
            this.queuelessExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
            this.getExecutorServiceInjector().inject((Object)this.queuelessExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        boolean ok;
        try {
            ServerEnvironment serverEnvironment = this.configuration.getServerEnvironment();
            ServiceTarget serviceTarget = context.getServiceTarget();
            serviceTarget.addListener(ServiceListener.Inheritance.ALL, (ServiceListener)this.bootstrapListener);
            File[] extDirs = serverEnvironment.getJavaExtDirs();
            File[] newExtDirs = Arrays.copyOf(extDirs, extDirs.length + 1);
            newExtDirs[extDirs.length] = new File(serverEnvironment.getServerBaseDir(), "lib/ext");
            serviceTarget.addService(org.jboss.as.server.deployment.Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX, (Service)new ExtensionIndexService(newExtDirs)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 4096, new DeploymentUnitProcessor(){

                @Override
                public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
                    phaseContext.getDeploymentUnit().putAttachment(Attachments.SERVICE_MODULE_LOADER, ServerService.this.injectedModuleLoader.getValue());
                    phaseContext.getDeploymentUnit().putAttachment(Attachments.EXTERNAL_MODULE_SERVICE, ServerService.this.injectedExternalModuleService.getValue());
                }

                @Override
                public void undeploy(DeploymentUnit context) {
                    context.removeAttachment(Attachments.SERVICE_MODULE_LOADER);
                }
            });
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 512, new DeploymentRootExplodedMountProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 768, new DeploymentRootMountProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 1024, new ManifestAttachmentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 5632, new ManifestAttachmentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 5888, new SubDeploymentProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 6656, new ModuleIdentifierProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 4352, new AnnotationIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 6144, new DeploymentStructureDescriptorParser());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 6400, new ManifestClassPathProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 768, new ManifestDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 769, new CompositeIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 1792, new ManifestExtensionListProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 2048, new ManifestExtensionNameProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 8704, new ServiceLoaderProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 256, new ModuleDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 1280, new ServiceActivatorDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 2048, new ModuleClassPathProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 2304, new ModuleExtensionListProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 3584, new SubDeploymentDependencyProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 4608, new ServerDependenciesProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 8448, new DeploymentVisibilityProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 5888, new DriverDependenciesProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.CONFIGURE_MODULE, 256, new ModuleSpecProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.POST_MODULE, 2560, new ModuleExtensionNameProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.POST_MODULE, 512, new InstallReflectionIndexProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.POST_MODULE, 513, new ClassFileTransformerProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.INSTALL, 1280, new ServiceActivatorProcessor());
            DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 2561, new Seam2Processor(serviceTarget));
            try {
                ok = this.boot(this.extensibleConfigurationPersister.load(), false);
                if (ok) {
                    this.finishBoot();
                }
            }
            finally {
                DeployerChainAddHandler.INSTANCE.clearDeployerMap();
            }
        }
        catch (Exception e) {
            ServerLogger.ROOT_LOGGER.caughtExceptionDuringBoot(e);
            ok = false;
        }
        if (ok) {
            this.bootstrapListener.tick();
        } else {
            ServerLogger.ROOT_LOGGER.unsuccessfulBoot();
            System.exit(1);
        }
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) throws ConfigurationPersistenceException {
        ArrayList<ModelNode> operations = new ArrayList<ModelNode>(bootOperations);
        operations.add(DeployerChainAddHandler.OPERATION);
        return super.boot(operations, rollbackOnRuntimeFailure);
    }

    public void stop(final StopContext context) {
        super.stop(context);
        this.configuration.getExtensionRegistry().clear();
        this.configuration.getServerEnvironment().resetProvidedProperties();
        if (this.queuelessExecutor != null) {
            context.asynchronous();
            Thread executorShutdown = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ServerService.this.queuelessExecutor.shutdown();
                    }
                    finally {
                        ServerService.this.queuelessExecutor = null;
                        context.complete();
                    }
                }
            }, "Controller ExecutorService Shutdown Thread");
            executorShutdown.start();
        }
    }

    protected void initModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        ServerControllerModelUtil.updateCoreModel(rootResource.getModel(), this.configuration.getServerEnvironment());
        ServerControllerModelUtil.initOperations(rootRegistration, (ContentRepository)this.injectedContentRepository.getValue(), this.extensibleConfigurationPersister, this.configuration.getServerEnvironment(), this.processState, this.runningModeControl, this.vaultReader, this.configuration.getExtensionRegistry(), this.queuelessExecutor != null, this.remoteFileRepository);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"management"), Resource.Factory.create());
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"service-container"), Resource.Factory.create());
        rootResource.registerChild(ServerEnvironmentResourceDescription.RESOURCE_PATH, Resource.Factory.create());
        rootResource.registerChild(PlatformMBeanConstants.ROOT_PATH, (Resource)new RootPlatformMBeanResource());
    }
}

