/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.util.concurrent.Semaphore;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ClientProducerCredits;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.logging.Logger;

public class ClientProducerCreditsImpl
implements ClientProducerCredits {
    private static final Logger log = Logger.getLogger(ClientProducerCreditsImpl.class);
    private final Semaphore semaphore;
    private final int windowSize;
    private volatile boolean closed;
    private boolean blocked;
    private final SimpleString address;
    private final ClientSessionInternal session;
    private int arriving;
    private int refCount;

    public ClientProducerCreditsImpl(ClientSessionInternal session, SimpleString address, int windowSize) {
        this.session = session;
        this.address = address;
        this.windowSize = windowSize / 2;
        this.semaphore = new Semaphore(0, false);
    }

    @Override
    public void init() {
        this.checkCredits(this.windowSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireCredits(int credits) throws InterruptedException {
        this.checkCredits(credits);
        if (!this.semaphore.tryAcquire(credits) && !this.closed) {
            this.blocked = true;
            try {
                this.semaphore.acquire(credits);
            }
            finally {
                this.blocked = false;
            }
        }
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    public int getBalance() {
        return this.semaphore.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveCredits(int credits) {
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            this.arriving -= credits;
        }
        this.semaphore.release(credits);
    }

    @Override
    public synchronized void reset() {
        this.semaphore.drainPermits();
        int beforeFailure = this.arriving;
        this.arriving = 0;
        this.checkCredits(Math.max(this.windowSize * 2, beforeFailure));
    }

    @Override
    public void close() {
        this.closed = true;
        this.semaphore.release(0x3FFFFFFF);
    }

    @Override
    public synchronized void incrementRefCount() {
        ++this.refCount;
    }

    @Override
    public synchronized int decrementRefCount() {
        return --this.refCount;
    }

    @Override
    public synchronized void releaseOutstanding() {
        this.semaphore.drainPermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCredits(int credits) {
        int needed = Math.max(credits, this.windowSize);
        int toRequest = -1;
        ClientProducerCreditsImpl clientProducerCreditsImpl = this;
        synchronized (clientProducerCreditsImpl) {
            if (this.semaphore.availablePermits() + this.arriving < needed) {
                toRequest = needed - this.arriving;
                this.arriving += toRequest;
            }
        }
        if (toRequest != -1) {
            this.requestCredits(toRequest);
        }
    }

    private void requestCredits(int credits) {
        this.session.sendProducerCreditsMessage(credits, this.address);
    }
}

