/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.custom;

import java.util.logging.Handler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.HandlerUpdateProperties;
import org.jboss.as.logging.handlers.custom.PropertiesConfigurator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CustomHandlerUpdateProperties
extends HandlerUpdateProperties<Handler> {
    public static final CustomHandlerUpdateProperties INSTANCE = new CustomHandlerUpdateProperties();

    private CustomHandlerUpdateProperties() {
        super("properties");
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, Handler handler) throws OperationFailedException {
        if (model.hasDefined("properties")) {
            ModelNode properties = model.get("properties");
            if (properties.getType() != ModelType.LIST) {
                throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidType("properties", ModelType.LIST, properties.getType())));
            }
            PropertiesConfigurator.setProperties(handler, properties.asPropertyList());
        }
        return false;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, String handlerName, ModelNode model, ModelNode originalModel, Handler handler) throws OperationFailedException {
        if (originalModel.hasDefined("properties")) {
            ModelNode properties = originalModel.get("properties");
            if (properties.getType() != ModelType.LIST) {
                throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidType("properties", ModelType.LIST, properties.getType())));
            }
            PropertiesConfigurator.setProperties(handler, properties.asPropertyList());
        }
    }
}

