/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.security.SecurityActions;

public class ExtendedFormAuthenticator
extends FormAuthenticator {
    public static final String LOGIN_EXCEPTION = "j_exception";
    public static final String DID_POPULATE = "did_populate";
    private boolean includePassword;

    public boolean isIncludePassword() {
        return this.includePassword;
    }

    public void setIncludePassword(boolean includePassword) {
        this.includePassword = includePassword;
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Boolean b;
        boolean didPopulate = false;
        boolean alreadyAuthenticated = super.authenticate(request, response, config);
        Session session = request.getSessionInternal(false);
        if (session != null && (b = (Boolean)session.getNote(DID_POPULATE)) != null) {
            didPopulate = b;
        }
        if (!alreadyAuthenticated && !didPopulate) {
            this.populateSession(request);
        }
        if (session != null) {
            session.removeNote(DID_POPULATE);
        }
        return alreadyAuthenticated;
    }

    protected void forwardToErrorPage(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        WebLogger.WEB_SECURITY_LOGGER.tracef("forwardToErrorPage", new Object[0]);
        this.populateSession(request);
        super.forwardToErrorPage(request, response, config);
        SecurityActions.clearAuthException();
    }

    protected void forwardToLoginPage(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        WebLogger.WEB_SECURITY_LOGGER.tracef("forwardToLoginPage", new Object[0]);
        this.populateSession(request);
        super.forwardToLoginPage(request, response, config);
    }

    protected void populateSession(Request request) {
        Session session = request.getSessionInternal(false);
        if (session != null) {
            HttpSession httpSession = session.getSession();
            WebLogger.WEB_SECURITY_LOGGER.tracef("SessionID: " + httpSession.getId(), new Object[0]);
            String username = request.getParameter("j_username");
            WebLogger.WEB_SECURITY_LOGGER.tracef("Setting j_username = " + username, new Object[0]);
            httpSession.setAttribute("j_username", (Object)username);
            if (this.includePassword) {
                String password = request.getParameter("j_password");
                String displayPassword = password == null ? " = null" : " = --hidden--";
                WebLogger.WEB_SECURITY_LOGGER.tracef("Setting j_password" + displayPassword, new Object[0]);
                httpSession.setAttribute("j_password", (Object)password);
            }
            Throwable t = SecurityActions.getAuthException();
            WebLogger.WEB_SECURITY_LOGGER.tracef("Setting j_exception = " + t, new Object[0]);
            httpSession.setAttribute(LOGIN_EXCEPTION, (Object)t);
            session.setNote(DID_POPULATE, (Object)Boolean.TRUE);
        } else {
            WebLogger.WEB_SECURITY_LOGGER.tracef("No Session to store login parameters in", new Object[0]);
        }
    }
}

