/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.entities.mapper.relation.AbstractCollectionMapper;
import org.hibernate.envers.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.entities.mapper.relation.lazy.initializor.ListCollectionInitializor;
import org.hibernate.envers.entities.mapper.relation.lazy.proxy.ListProxy;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.Pair;
import org.hibernate.envers.tools.Tools;

public final class ListCollectionMapper
extends AbstractCollectionMapper<List>
implements PropertyMapper {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public ListCollectionMapper(CommonCollectionMapperData commonCollectionMapperData, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(commonCollectionMapperData, List.class, ListProxy.class);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Initializor<List> getInitializor(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Object primaryKey, Number revision) {
        return new ListCollectionInitializor(verCfg, versionsReader, this.commonCollectionMapperData.getQueryGenerator(), primaryKey, revision, this.elementComponentData, this.indexComponentData);
    }

    @Override
    protected Collection getNewCollectionContent(PersistentCollection newCollection) {
        if (newCollection == null) {
            return null;
        }
        return Tools.listToIndexElementPairList((List)newCollection);
    }

    @Override
    protected Collection getOldCollectionContent(Serializable oldCollection) {
        if (oldCollection == null) {
            return null;
        }
        return Tools.listToIndexElementPairList((List)((Object)oldCollection));
    }

    @Override
    protected void mapToMapFromObject(Map<String, Object> data, Object changed) {
        Pair indexValuePair = (Pair)changed;
        this.elementComponentData.getComponentMapper().mapToMapFromObject(data, indexValuePair.getSecond());
        this.indexComponentData.getComponentMapper().mapToMapFromObject(data, indexValuePair.getFirst());
    }
}

