/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.client;

import java.util.List;
import javax.transaction.xa.XAResource;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.api.core.client.SessionFailureListener;

public interface ClientSession
extends XAResource {
    public void start() throws HornetQException;

    public void stop() throws HornetQException;

    public void close() throws HornetQException;

    public boolean isClosed();

    public void addFailureListener(SessionFailureListener var1);

    public boolean removeFailureListener(SessionFailureListener var1);

    public int getVersion();

    public void createQueue(SimpleString var1, SimpleString var2, boolean var3) throws HornetQException;

    public void createQueue(String var1, String var2, boolean var3) throws HornetQException;

    public void createQueue(String var1, String var2) throws HornetQException;

    public void createQueue(SimpleString var1, SimpleString var2) throws HornetQException;

    public void createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4) throws HornetQException;

    public void createQueue(String var1, String var2, String var3, boolean var4) throws HornetQException;

    public void createTemporaryQueue(SimpleString var1, SimpleString var2) throws HornetQException;

    public void createTemporaryQueue(String var1, String var2) throws HornetQException;

    public void createTemporaryQueue(SimpleString var1, SimpleString var2, SimpleString var3) throws HornetQException;

    public void createTemporaryQueue(String var1, String var2, String var3) throws HornetQException;

    public void deleteQueue(SimpleString var1) throws HornetQException;

    public void deleteQueue(String var1) throws HornetQException;

    public ClientConsumer createConsumer(SimpleString var1) throws HornetQException;

    public ClientConsumer createConsumer(String var1) throws HornetQException;

    public ClientConsumer createConsumer(SimpleString var1, SimpleString var2) throws HornetQException;

    public ClientConsumer createConsumer(String var1, String var2) throws HornetQException;

    public ClientConsumer createConsumer(SimpleString var1, boolean var2) throws HornetQException;

    public ClientConsumer createConsumer(String var1, boolean var2) throws HornetQException;

    public ClientConsumer createConsumer(String var1, String var2, boolean var3) throws HornetQException;

    public ClientConsumer createConsumer(SimpleString var1, SimpleString var2, boolean var3) throws HornetQException;

    public ClientConsumer createConsumer(SimpleString var1, SimpleString var2, int var3, int var4, boolean var5) throws HornetQException;

    public ClientConsumer createConsumer(String var1, String var2, int var3, int var4, boolean var5) throws HornetQException;

    public ClientProducer createProducer() throws HornetQException;

    public ClientProducer createProducer(SimpleString var1) throws HornetQException;

    public ClientProducer createProducer(String var1) throws HornetQException;

    public ClientProducer createProducer(SimpleString var1, int var2) throws HornetQException;

    public ClientMessage createMessage(boolean var1);

    public ClientMessage createMessage(byte var1, boolean var2);

    public ClientMessage createMessage(byte var1, boolean var2, long var3, long var5, byte var7);

    public QueueQuery queueQuery(SimpleString var1) throws HornetQException;

    public BindingQuery bindingQuery(SimpleString var1) throws HornetQException;

    public XAResource getXAResource();

    public boolean isXA();

    public void commit() throws HornetQException;

    public void rollback() throws HornetQException;

    public void rollback(boolean var1) throws HornetQException;

    public boolean isRollbackOnly();

    public boolean isAutoCommitSends();

    public boolean isAutoCommitAcks();

    public boolean isBlockOnAcknowledge();

    public void setSendAcknowledgementHandler(SendAcknowledgementHandler var1);

    public void addMetaData(String var1, String var2) throws HornetQException;

    public void addUniqueMetaData(String var1, String var2) throws HornetQException;

    public void addMetaDataV1(String var1, String var2) throws HornetQException;

    public static interface QueueQuery {
        public boolean isExists();

        public boolean isDurable();

        public int getConsumerCount();

        public long getMessageCount();

        public SimpleString getFilterString();

        public SimpleString getAddress();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BindingQuery {
        public boolean isExists();

        public List<SimpleString> getQueueNames();
    }
}

