/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.util.AddressAdapter;
import org.hibernate.cache.infinispan.util.AddressAdapterImpl;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.hibernate.cache.infinispan.util.CacheHelper;
import org.hibernate.cache.infinispan.util.EvictAllCommand;
import org.hibernate.cache.infinispan.util.FlagAdapter;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheAdapterImpl
implements CacheAdapter {
    private static final Log log = LogFactory.getLog(CacheAdapterImpl.class);
    private final AdvancedCache cache;
    private final CacheCommandInitializer cacheCmdInitializer;
    private final boolean isSync;

    private CacheAdapterImpl(AdvancedCache cache) {
        this.cache = cache;
        this.cacheCmdInitializer = (CacheCommandInitializer)cache.getComponentRegistry().getComponent(CacheCommandInitializer.class);
        this.isSync = CacheAdapterImpl.isSynchronous(cache.getConfiguration().getCacheMode());
    }

    public static CacheAdapter newInstance(AdvancedCache cache) {
        return new CacheAdapterImpl(cache);
    }

    @Override
    public boolean isClusteredInvalidation() {
        return CacheAdapterImpl.isClusteredInvalidation(this.cache.getConfiguration().getCacheMode());
    }

    @Override
    public boolean isClusteredReplication() {
        return CacheAdapterImpl.isClusteredReplication(this.cache.getConfiguration().getCacheMode());
    }

    @Override
    public boolean isSynchronous() {
        return this.isSync;
    }

    @Override
    public Set keySet() {
        return this.cache.keySet();
    }

    @Override
    public CacheAdapter withFlags(FlagAdapter ... flagAdapters) {
        Flag[] flags = FlagAdapter.toFlags(flagAdapters);
        return CacheAdapterImpl.newInstance(this.cache.withFlags(flags));
    }

    @Override
    public Object get(Object key) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public Object getAllowingTimeout(Object key) throws CacheException {
        try {
            return this.getFailSilentCache().get(key);
        }
        catch (TimeoutException ignored) {
            return null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        try {
            this.getSkipRemoteGetLoadCache().put(key, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void putAllowingTimeout(Object key, Object value) throws CacheException {
        try {
            this.getFailSilentCacheSkipRemotes().put(key, value);
        }
        catch (TimeoutException allowed) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void putForExternalRead(Object key, Object value) throws CacheException {
        try {
            this.getFailSilentCacheSkipRemotes().putForExternalRead(key, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void remove(Object key) throws CacheException {
        try {
            this.getSkipRemoteGetLoadCache().remove(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        try {
            this.cache.evict(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void clear() throws CacheException {
        try {
            this.cache.clear();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Stop " + this.cache));
        }
        this.cache.stop();
    }

    private static boolean isClusteredInvalidation(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.INVALIDATION_ASYNC || cacheMode == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    private static boolean isClusteredReplication(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.REPL_ASYNC || cacheMode == Configuration.CacheMode.REPL_SYNC;
    }

    private static boolean isSynchronous(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.REPL_SYNC || cacheMode == Configuration.CacheMode.INVALIDATION_SYNC || cacheMode == Configuration.CacheMode.DIST_SYNC;
    }

    @Override
    public void addListener(Object listener) {
        this.cache.addListener(listener);
    }

    @Override
    public AddressAdapter getAddress() {
        RpcManager rpc = this.cache.getRpcManager();
        if (rpc != null) {
            return AddressAdapterImpl.newInstance(rpc.getTransport().getAddress());
        }
        return null;
    }

    @Override
    public List<AddressAdapter> getMembers() {
        RpcManager rpc = this.cache.getRpcManager();
        if (rpc != null) {
            return AddressAdapterImpl.toAddressAdapter(rpc.getTransport().getMembers());
        }
        return null;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Map toMap() {
        return this.cache;
    }

    @Override
    public void removeListener(Object listener) {
        this.cache.removeListener(listener);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public Configuration getConfiguration() {
        return this.cache.getConfiguration();
    }

    @Override
    public void broadcastEvictAll() {
        EvictAllCommand cmd = this.cacheCmdInitializer.buildEvictAllCommand(this.cache.getName());
        this.cache.getRpcManager().broadcastRpcCommand((ReplicableCommand)cmd, this.isSync);
    }

    @Override
    public <T> T withinTx(Callable<T> c) throws Exception {
        return CacheHelper.withinTx(this.cache.getTransactionManager(), c);
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    private Cache getFailSilentCache() {
        return this.cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY});
    }

    private Cache getSkipRemoteGetLoadCache() {
        return this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP});
    }

    private Cache getFailSilentCacheSkipRemotes() {
        return this.cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP});
    }
}

