/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Calendar;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.CalendarTimerEntity;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.as.ejb3.timerservice.persistence.TimerEntity;
import org.jboss.as.ejb3.timerservice.schedule.CalendarBasedTimeout;
import org.jboss.as.ejb3.timerservice.task.CalendarTimerTask;
import org.jboss.as.ejb3.timerservice.task.TimerTask;

public class CalendarTimer
extends TimerImpl {
    private final CalendarBasedTimeout calendarTimeout;
    private final boolean autoTimer;
    private final Method timeoutMethod;

    public CalendarTimer(String id, TimerServiceImpl timerService, CalendarBasedTimeout calendarTimeout, Object primaryKey) {
        this(id, timerService, calendarTimeout, null, true, primaryKey);
    }

    public CalendarTimer(String id, TimerServiceImpl timerService, CalendarBasedTimeout calendarTimeout, Serializable info, boolean persistent, Object primaryKey) {
        this(id, timerService, calendarTimeout, info, persistent, null, primaryKey);
    }

    public CalendarTimer(String id, TimerServiceImpl timerService, CalendarBasedTimeout calendarTimeout, Serializable info, boolean persistent, Method timeoutMethod, Object primaryKey) {
        super(id, timerService, calendarTimeout.getFirstTimeout() == null ? null : calendarTimeout.getFirstTimeout().getTime(), 0L, info, persistent, primaryKey, TimerState.CREATED);
        this.calendarTimeout = calendarTimeout;
        Calendar nextTimeout = this.calendarTimeout.getNextTimeout();
        if (nextTimeout != null) {
            this.nextExpiration = nextTimeout.getTime();
        }
        if (timeoutMethod != null) {
            this.autoTimer = true;
            this.timeoutMethod = timeoutMethod;
        } else {
            this.autoTimer = false;
            this.timeoutMethod = null;
        }
    }

    public CalendarTimer(CalendarTimerEntity persistedCalendarTimer, TimerServiceImpl timerService) {
        super(persistedCalendarTimer, timerService);
        this.calendarTimeout = persistedCalendarTimer.getCalendarTimeout();
        this.nextExpiration = persistedCalendarTimer.getNextDate();
        if (persistedCalendarTimer.isAutoTimer()) {
            this.autoTimer = true;
            TimeoutMethod timeoutMethodInfo = persistedCalendarTimer.getTimeoutMethod();
            this.timeoutMethod = this.getTimeoutMethod(timeoutMethodInfo);
            if (this.timeoutMethod == null) {
                throw EjbMessages.MESSAGES.failToFindTimeoutMethod(timeoutMethodInfo);
            }
        } else {
            this.autoTimer = false;
            this.timeoutMethod = null;
        }
    }

    @Override
    public ScheduleExpression getSchedule() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return this.calendarTimeout.getScheduleExpression();
    }

    public ScheduleExpression getScheduleExpression() {
        return this.calendarTimeout.getScheduleExpression();
    }

    @Override
    public boolean isCalendarTimer() throws IllegalStateException, EJBException {
        this.assertTimerState();
        return true;
    }

    @Override
    protected TimerEntity createPersistentState() {
        return new CalendarTimerEntity(this);
    }

    public CalendarBasedTimeout getCalendarTimeout() {
        return this.calendarTimeout;
    }

    @Override
    public boolean isAutoTimer() {
        return this.autoTimer;
    }

    @Override
    protected TimerTask<?> getTimerTask() {
        return new CalendarTimerTask(this);
    }

    public Method getTimeoutMethod() {
        if (!this.autoTimer) {
            throw EjbMessages.MESSAGES.failToInvokegetTimeoutMethod();
        }
        return this.timeoutMethod;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.handle == null) {
            return false;
        }
        if (!(obj instanceof CalendarTimer)) {
            return false;
        }
        CalendarTimer otherTimer = (CalendarTimer)obj;
        return this.handle.equals(otherTimer.getTimerHandle());
    }

    private Method getTimeoutMethod(TimeoutMethod timeoutMethodInfo) {
        String declaringClass = timeoutMethodInfo.getDeclaringClass();
        Class<?> timeoutMethodDeclaringClass = null;
        try {
            timeoutMethodDeclaringClass = Class.forName(declaringClass, false, this.timedObjectInvoker.getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw EjbMessages.MESSAGES.failToLoadDeclaringClassOfTimeOut(declaringClass);
        }
        String timeoutMethodName = timeoutMethodInfo.getMethodName();
        String[] timeoutMethodParams = timeoutMethodInfo.getMethodParams();
        Class[] timeoutMethodParamTypes = new Class[]{};
        if (timeoutMethodParams != null) {
            timeoutMethodParamTypes = new Class[timeoutMethodParams.length];
            int i = 0;
            for (String paramClassName : timeoutMethodParams) {
                Class<?> methodParamClass = null;
                try {
                    methodParamClass = Class.forName(paramClassName, false, this.timedObjectInvoker.getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Could not load method param class: " + paramClassName + " of timeout method", cnfe);
                }
                timeoutMethodParamTypes[i++] = methodParamClass;
            }
        }
        for (Class<?> klass = timeoutMethodDeclaringClass; klass != null; klass = klass.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = klass.getDeclaredMethods()) {
                Class<?>[] methodParamTypes;
                if (!method.getName().equals(timeoutMethodName) || timeoutMethodParamTypes.length != (methodParamTypes = method.getParameterTypes()).length) continue;
                boolean match = true;
                for (int i = 0; i < methodParamTypes.length; ++i) {
                    if (timeoutMethodParamTypes[i].equals(methodParamTypes[i])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return method;
            }
        }
        return null;
    }
}

