/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionManagementTask;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.Channel;

class XidTransactionRollbackTask
extends XidTransactionManagementTask {
    XidTransactionRollbackTask(TransactionRequestHandler txRequestHandler, EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, XidTransactionID xidTransactionID, Channel channel, short invocationId) {
        super(txRequestHandler, transactionsRepository, marshallerFactory, xidTransactionID, channel, invocationId);
    }

    @Override
    protected void manageTransaction() throws Throwable {
        block15: {
            Transaction transaction = this.transactionsRepository.removeTransaction((TransactionID)this.xidTransactionID);
            if (transaction == null) {
                if (EjbLogger.EJB3_INVOCATION_LOGGER.isDebugEnabled()) {
                    EjbLogger.EJB3_INVOCATION_LOGGER.debug("Not rolling back transaction " + this.xidTransactionID + " as is was not found on the server");
                }
                return;
            }
            this.resumeTransaction(transaction);
            Xid xid = this.xidTransactionID.getXid();
            try {
                SubordinateTransaction subordinateTransaction = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
                if (subordinateTransaction == null) {
                    throw new XAException(-5);
                }
                if (subordinateTransaction.activated()) {
                    subordinateTransaction.doRollback();
                    SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                    break block15;
                }
                throw new XAException(4);
            }
            catch (XAException ex) {
                if (ex.errorCode != 4) {
                    SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                }
                throw ex;
            }
            catch (HeuristicRollbackException ex) {
                XAException xaException = new XAException(6);
                xaException.initCause(ex);
                throw xaException;
            }
            catch (HeuristicCommitException ex) {
                XAException xaException = new XAException(7);
                xaException.initCause(ex);
                throw xaException;
            }
            catch (HeuristicMixedException ex) {
                XAException xaException = new XAException(5);
                xaException.initCause(ex);
                throw xaException;
            }
            catch (IllegalStateException ex) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                XAException xaException = new XAException(-4);
                xaException.initCause(ex);
                throw xaException;
            }
            catch (SystemException ex) {
                SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                throw new XAException(-3);
            }
            finally {
                this.transactionsRepository.getTransactionManager().suspend();
            }
        }
    }
}

