/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class DeploymentRepository
implements Service<DeploymentRepository> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ee", "deploymentRepository"});
    private static final Logger logger = Logger.getLogger(DeploymentRepository.class);
    private volatile Map<DeploymentModuleIdentifier, ModuleDeployment> modules;
    private final List<DeploymentRepositoryListener> listeners = new ArrayList<DeploymentRepositoryListener>();

    public void start(StartContext context) throws StartException {
        this.modules = Collections.emptyMap();
    }

    public void stop(StopContext context) {
        this.modules = null;
    }

    public DeploymentRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public synchronized void add(DeploymentModuleIdentifier identifier, ModuleDeployment deployment) {
        HashMap<DeploymentModuleIdentifier, ModuleDeployment> modules = new HashMap<DeploymentModuleIdentifier, ModuleDeployment>(this.modules);
        modules.put(identifier, deployment);
        this.modules = Collections.unmodifiableMap(modules);
        for (DeploymentRepositoryListener listener : this.listeners) {
            try {
                listener.deploymentAvailable(identifier, deployment);
            }
            catch (Throwable t) {
                logger.error((Object)"Exception calling deployment added listener", t);
            }
        }
    }

    public synchronized void addListener(DeploymentRepositoryListener listener) {
        listener.listenerAdded(this);
        this.listeners.add(listener);
    }

    public synchronized void removeListener(DeploymentRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void remove(DeploymentModuleIdentifier identifier) {
        HashMap<DeploymentModuleIdentifier, ModuleDeployment> modules = new HashMap<DeploymentModuleIdentifier, ModuleDeployment>(this.modules);
        modules.remove(identifier);
        this.modules = Collections.unmodifiableMap(modules);
        for (DeploymentRepositoryListener listener : this.listeners) {
            try {
                listener.deploymentRemoved(identifier);
            }
            catch (Throwable t) {
                logger.error((Object)"Exception calling deployment removal listener", t);
            }
        }
    }

    public Map<DeploymentModuleIdentifier, ModuleDeployment> getModules() {
        return this.modules;
    }
}

