/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import javax.ejb.EJBException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.ReadAheadCache;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.logging.Logger;

public final class JDBCLoadEntityCommand {
    private final JDBCStoreManager manager;
    private final JDBCEntityBridge entity;
    private final Logger log;
    private final JDBCFunctionMappingMetaData rowLockingTemplate;

    public JDBCLoadEntityCommand(JDBCStoreManager manager) {
        this.manager = manager;
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        boolean rowLocking = this.entity.getMetaData().hasRowLocking();
        this.rowLockingTemplate = rowLocking ? this.entity.getMetaData().getTypeMapping().getRowLockingTemplate() : null;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
    }

    public boolean execute(CmpEntityBeanContext ctx, boolean failIfNotFound) {
        return this.execute(null, ctx, failIfNotFound);
    }

    public void execute(JDBCCMPFieldBridge requiredField, CmpEntityBeanContext ctx) {
        this.execute(requiredField, ctx, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean execute(JDBCCMPFieldBridge requiredField, CmpEntityBeanContext ctx, boolean failIfNotFound) {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block17: {
            Object id = ctx.getPrimaryKey();
            this.entity.injectPrimaryKeyIntoInstance(ctx, id);
            ReadAheadCache readAheadCache = this.manager.getReadAheadCache();
            if (readAheadCache.load(ctx) && (requiredField == null || requiredField != null && requiredField.isLoaded(ctx))) {
                return true;
            }
            ReadAheadCache.EntityReadAheadInfo info = readAheadCache.getEntityReadAheadInfo(id);
            JDBCEntityBridge.FieldIterator loadIter = this.entity.getLoadIterator(requiredField, info.getReadAhead(), ctx);
            if (!loadIter.hasNext()) {
                return true;
            }
            List loadKeys = info.getLoadKeys();
            String sql = this.rowLockingTemplate != null ? this.getRawLockingSQL(loadIter, loadKeys.size()) : this.getSQL(loadIter, loadKeys.size());
            con = null;
            ps = null;
            rs = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Executing SQL: " + sql));
            }
            con = this.entity.getDataSource().getConnection();
            ps = con.prepareStatement(sql);
            if (this.entity.getFetchSize() > 0) {
                ps.setFetchSize(this.entity.getFetchSize());
            }
            int paramIndex = 1;
            for (int i = 0; i < loadKeys.size(); ++i) {
                paramIndex = this.entity.setPrimaryKeyParameters(ps, paramIndex, loadKeys.get(i));
            }
            rs = ps.executeQuery();
            boolean mainEntityLoaded = false;
            Object[] ref = new Object[1];
            while (rs.next()) {
                JDBCCMPFieldBridge field;
                int index = 1;
                ref[0] = null;
                Object pk = null;
                if (loadKeys.size() > 1) {
                    index = this.entity.loadPrimaryKeyResults(rs, index, ref);
                    pk = ref[0];
                }
                if (loadKeys.size() == 1 || pk.equals(id)) {
                    loadIter.reset();
                    while (loadIter.hasNext()) {
                        field = loadIter.next();
                        index = field.loadInstanceResults(rs, index, ctx);
                        field.setClean(ctx);
                    }
                    mainEntityLoaded = true;
                    continue;
                }
                loadIter.reset();
                while (loadIter.hasNext()) {
                    field = loadIter.next();
                    ref[0] = null;
                    index = field.loadArgumentResults(rs, index, ref);
                    readAheadCache.addPreloadData(pk, field, ref[0]);
                }
            }
            loadIter.removeAll();
            if (mainEntityLoaded) break block17;
            if (failIfNotFound) {
                throw CmpMessages.MESSAGES.entityNotFound(ctx.getPrimaryKey());
            }
            bl = false;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            return bl;
        }
        try {
            bl = true;
        }
        catch (EJBException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw CmpMessages.MESSAGES.entityLoadFailed(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        return bl;
    }

    private String getSQL(JDBCEntityBridge.FieldIterator loadIter, int keyCount) {
        StringBuffer sql = new StringBuffer(250);
        sql.append("SELECT ");
        JDBCFieldBridge[] primaryKeyFields = this.entity.getPrimaryKeyFields();
        if (keyCount > 1) {
            SQLUtil.getColumnNamesClause(primaryKeyFields, sql);
            sql.append(", ");
        }
        SQLUtil.getColumnNamesClause(loadIter, sql);
        sql.append(" FROM ").append(this.entity.getQualifiedTableName()).append(" WHERE ");
        String pkWhere = SQLUtil.getWhereClause(primaryKeyFields, new StringBuffer(50)).toString();
        sql.append('(').append(pkWhere).append(')');
        for (int i = 1; i < keyCount; ++i) {
            sql.append(" OR ").append('(').append(pkWhere).append(')');
        }
        return sql.toString();
    }

    private String getRawLockingSQL(JDBCEntityBridge.FieldIterator loadIter, int keyCount) {
        StringBuffer columnNamesClause = new StringBuffer(250);
        if (keyCount > 1) {
            SQLUtil.getColumnNamesClause(this.entity.getPrimaryKeyFields(), columnNamesClause);
            columnNamesClause.append(", ");
        }
        SQLUtil.getColumnNamesClause(loadIter, columnNamesClause);
        String tableName = this.entity.getQualifiedTableName();
        String whereClause = SQLUtil.getWhereClause(this.entity.getPrimaryKeyFields(), new StringBuffer(50)).toString();
        if (keyCount > 0) {
            StringBuffer sb = new StringBuffer((whereClause.length() + 6) * keyCount + 4);
            for (int i = 0; i < keyCount; ++i) {
                if (i > 0) {
                    sb.append(" OR ");
                }
                sb.append('(').append(whereClause).append(')');
            }
            whereClause = sb.toString();
        }
        Object[] args = new String[]{columnNamesClause.toString(), tableName, whereClause, null};
        return this.rowLockingTemplate.getFunctionSql(args, new StringBuffer(300)).toString();
    }
}

