/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;

public final class JDBCDeclaredSQLQuery
extends JDBCAbstractQueryCommand {
    private final JDBCDeclaredQueryMetaData metadata;

    public JDBCDeclaredSQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q) {
        super(manager, q);
        this.metadata = (JDBCDeclaredQueryMetaData)q;
        this.initSelectObject(manager);
        JDBCReadAheadMetaData readAhead = this.metadata.getReadAhead();
        JDBCEntityBridge selectEntity = this.getSelectEntity();
        if (selectEntity != null && readAhead.isOnFind()) {
            this.setEagerLoadGroup(readAhead.getEagerLoadGroup());
        }
        String sql = this.buildSQL();
        this.setSQL(this.parseParameters(sql));
    }

    private void initSelectObject(JDBCStoreManager manager) {
        String entityName = this.metadata.getEJBName();
        if (entityName == null) {
            return;
        }
        Catalog catalog = manager.getCatalog();
        JDBCEntityBridge entity = (JDBCEntityBridge)catalog.getEntityByEJBName(entityName);
        if (entity == null) {
            throw CmpMessages.MESSAGES.unknownEntity(entityName);
        }
        String fieldName = this.metadata.getFieldName();
        if (fieldName == null) {
            this.setSelectEntity(entity);
        } else {
            JDBCCMPFieldBridge field = entity.getCMPFieldByName(fieldName);
            if (field == null) {
                throw CmpMessages.MESSAGES.unknownCmpField(fieldName);
            }
            this.setSelectField(field);
        }
    }

    private String buildSQL() {
        String other;
        String order;
        String where;
        String selectList;
        String table;
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT ");
        if (this.metadata.isSelectDistinct()) {
            sql.append("DISTINCT ");
        }
        String alias = this.metadata.getAlias();
        String from = this.metadata.getFrom();
        if (this.getSelectField() == null) {
            table = this.getSelectEntity().getQualifiedTableName();
            String tableAlias = JDBCDeclaredSQLQuery.getTableAlias(alias, from, this.getSelectEntity().getTableName());
            selectList = SQLUtil.getColumnNamesClause(this.getSelectEntity().getPrimaryKeyFields(), tableAlias, new StringBuffer(35)).toString();
            if (this.getEagerLoadGroup() != null) {
                selectList = selectList + SQLUtil.appendColumnNamesClause(this.getSelectEntity(), this.getEagerLoadGroup(), tableAlias, new StringBuffer(35));
            }
        } else {
            JDBCCMPFieldBridge selectField = this.getSelectField();
            JDBCStoreManager manager = (JDBCStoreManager)this.getSelectField().getManager();
            table = manager.getEntityBridge().getQualifiedTableName();
            selectList = SQLUtil.getColumnNamesClause(selectField, JDBCDeclaredSQLQuery.getTableAlias(alias, from, manager.getEntityBridge().getTableName()), new StringBuffer()).toString();
        }
        sql.append(selectList);
        String additionalColumns = this.metadata.getAdditionalColumns();
        if (additionalColumns != null) {
            sql.append(additionalColumns);
        }
        sql.append(" FROM ").append(table);
        if (alias != null) {
            sql.append(' ').append(alias);
        }
        if (from != null) {
            sql.append(' ').append(from);
        }
        if ((where = this.metadata.getWhere()) != null && where.trim().length() > 0) {
            sql.append(" WHERE ").append(where);
        }
        if ((order = this.metadata.getOrder()) != null && order.trim().length() > 0) {
            sql.append(" ORDER BY ").append(order);
        }
        if ((other = this.metadata.getOther()) != null && other.trim().length() > 0) {
            sql.append(' ').append(other);
        }
        return sql.toString();
    }

    private static String getTableAlias(String alias, String from, String table) {
        String tableAlias = alias != null ? alias : (from != null ? table : "");
        return tableAlias;
    }
}

