/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.tools.interfaces.WebservicesXMLCreator;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebservicesXMLCreatorImpl
implements WebservicesXMLCreator {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WebservicesXMLCreatorImpl.class);
    protected static final Logger log = Logger.getLogger(WebservicesXMLCreatorImpl.class);
    protected String targetNamespace = null;
    protected String seiName = null;
    protected String portName = null;
    protected String serviceName = null;
    protected String servletLink = null;
    protected String ejbLink = null;
    protected String wsdlFile = null;
    protected String mappingFile = null;
    protected boolean append = false;

    @Override
    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    public void setSeiName(String seiName) {
        this.seiName = seiName;
    }

    @Override
    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void setEjbLink(String ejbLink) {
        this.ejbLink = ejbLink;
    }

    @Override
    public void setServletLink(String servletLink) {
        this.servletLink = servletLink;
    }

    @Override
    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    @Override
    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    @Override
    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public void generateWSXMLDescriptor(File wsXmlFile) throws IOException {
        WebservicesMetaData webservices = this.constructWSMetaData();
        if (this.append && wsXmlFile.exists()) {
            WebservicesMetaData existingWebservices;
            FileInputStream wsXmlStream = new FileInputStream(wsXmlFile);
            try {
                existingWebservices = WebservicesFactory.parse((InputStream)wsXmlStream, (URL)wsXmlFile.toURI().toURL());
            }
            catch (Exception e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_UNMARSHAL_DESCRIPTOR", (Object[])new Object[]{wsXmlFile}), e);
            }
            finally {
                ((InputStream)wsXmlStream).close();
            }
            for (WebserviceDescriptionMetaData webserviceDescription : webservices.getWebserviceDescriptions()) {
                existingWebservices.addWebserviceDescription(webserviceDescription);
            }
            webservices = existingWebservices;
        }
        Element root = DOMUtils.parse((String)webservices.serialize());
        FileWriter fwriter = new FileWriter(wsXmlFile);
        new DOMWriter((Writer)fwriter).setPrettyprint(true).print((Node)root);
        fwriter.close();
    }

    private WebservicesMetaData constructWSMetaData() {
        WebservicesMetaData wm = new WebservicesMetaData();
        WebserviceDescriptionMetaData wsdm = new WebserviceDescriptionMetaData(wm);
        this.populateWebserviceDescriptionMetaData(wsdm);
        wm.addWebserviceDescription(wsdm);
        return wm;
    }

    private void populateWebserviceDescriptionMetaData(WebserviceDescriptionMetaData wsdm) {
        this.checkEssentials();
        wsdm.setWebserviceDescriptionName(this.serviceName);
        wsdm.setWsdlFile(this.wsdlFile);
        wsdm.setJaxrpcMappingFile(this.mappingFile);
        PortComponentMetaData pm1 = new PortComponentMetaData(wsdm);
        pm1.setPortComponentName(this.portName);
        pm1.setWsdlPort(new QName(this.targetNamespace, this.portName, "portNS"));
        pm1.setServiceEndpointInterface(this.seiName);
        if (this.servletLink != null && this.servletLink.length() > 0) {
            pm1.setServletLink(this.servletLink);
        } else {
            pm1.setEjbLink(this.ejbLink);
        }
        wsdm.addPortComponent(pm1);
    }

    private void checkEssentials() {
        if (this.serviceName == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SERVICENAME_IS_NULL", (Object[])new Object[0]));
        }
        if (this.wsdlFile == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"WSDLFILE_IS_NULL", (Object[])new Object[0]));
        }
        if (this.mappingFile == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MAPPINGFILE_IS_NULL", (Object[])new Object[0]));
        }
        if (this.targetNamespace == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"TARGETNAMESPACE_IS_NULL", (Object[])new Object[0]));
        }
        if (this.portName == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"PORTNAME_IS_NULL", (Object[])new Object[0]));
        }
        if (this.seiName == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SEINAME_IS_NULL", (Object[])new Object[0]));
        }
        if (this.servletLink == null && this.ejbLink == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"EITHER_SERVLETLINK_OR_EJBLINK_SHOULD_NOT_BE_NULL", (Object[])new Object[0]));
        }
        if (this.servletLink != null && this.ejbLink != null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONE_OF_SERVLETLINK_OR_EJBLINK_SHOULD_BE_NULL", (Object[])new Object[0]));
        }
    }
}

