/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.DOMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaExtractor {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SchemaExtractor.class);
    private static Logger log = Logger.getLogger(SchemaExtractor.class);
    private File xsdFile;
    private String path;

    public InputStream[] getSchemas(URL wsdlURL) throws IOException {
        QName typesQName;
        Pattern p = Pattern.compile("[a-zA-Z]+\\.[a-zA-Z]+$");
        Matcher m = p.matcher(wsdlURL.getFile());
        this.path = m.replaceFirst("");
        Element root = DOMUtils.parse((InputStream)wsdlURL.openStream());
        Element typesEl = DOMUtils.getFirstChildElement((Node)root, (QName)(typesQName = new QName(root.getNamespaceURI(), "types")));
        if (typesEl == null) {
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_ELEMENT", (Object[])new Object[]{typesQName}));
            return null;
        }
        QName schemaQName = new QName("http://www.w3.org/2001/XMLSchema", "schema");
        List schemaElements = DOMUtils.getChildElementsAsList((Node)typesEl, (QName)schemaQName);
        if (schemaElements.size() == 0) {
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_ELEMENT", (Object[])new Object[]{schemaQName}));
            return null;
        }
        if (schemaElements.size() > 1) {
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"MULTIPLE_SCHEMA_ELEMENTS_NOT_SUPPORTED", (Object[])new Object[0]));
        }
        Element schemaElement = (Element)schemaElements.get(0);
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        this.pullImportedSchemas(schemaElement, streams);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        OutputStreamWriter outwr = new OutputStreamWriter(outStream);
        DOMWriter domWriter = new DOMWriter((Writer)outwr);
        domWriter.setPrettyprint(true);
        domWriter.print((Node)schemaElement);
        streams.add(new ByteArrayInputStream(outStream.toByteArray()));
        return streams.toArray(new InputStream[streams.size()]);
    }

    private void pullImportedSchemas(Element schemaElement, List<InputStream> streams) {
        String schemaLocation;
        QName importQName = new QName("http://www.w3.org/2001/XMLSchema", "import");
        List importElements = DOMUtils.getChildElementsAsList((Node)schemaElement, (QName)importQName);
        ArrayList<String> schemaLocations = new ArrayList<String>();
        for (Element importElement : importElements) {
            schemaLocation = importElement.getAttribute("schemaLocation");
            schemaLocations.add(schemaLocation);
        }
        ByteArrayOutputStream outStream = null;
        for (int i = 0; i < schemaLocations.size(); ++i) {
            schemaLocation = (String)schemaLocations.get(i);
            try {
                FileInputStream in = new FileInputStream(this.path + schemaLocation);
                outStream = new ByteArrayOutputStream();
                int bt = 0;
                while ((bt = in.read()) != -1) {
                    outStream.write((byte)bt);
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
                ((InputStream)inputStream).mark(0);
                Element root = DOMUtils.parse((InputStream)inputStream);
                this.pullImportedSchemas(root, streams);
                ((InputStream)inputStream).reset();
                streams.add(inputStream);
                continue;
            }
            catch (IOException ioe) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_OBTAINING_SCHEMA", (Object[])new Object[]{this.path}));
            }
        }
    }
}

