/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.xml.security.Init;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.security.SecurityActions;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.EncryptedKey;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.SecurityProcess;
import org.jboss.ws.extensions.security.element.Signature;
import org.jboss.ws.extensions.security.element.Timestamp;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.ws.extensions.security.element.UsernameToken;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.nonce.NonceFactory;
import org.jboss.ws.extensions.security.operation.DecryptionOperation;
import org.jboss.ws.extensions.security.operation.ReceiveUsernameOperation;
import org.jboss.ws.extensions.security.operation.ReceiveX509Certificate;
import org.jboss.ws.extensions.security.operation.RequireEncryptionOperation;
import org.jboss.ws.extensions.security.operation.RequireOperation;
import org.jboss.ws.extensions.security.operation.RequireSignatureOperation;
import org.jboss.ws.extensions.security.operation.SignatureVerificationOperation;
import org.jboss.ws.extensions.security.operation.TimestampVerificationOperation;
import org.jboss.ws.metadata.wsse.Authenticate;
import org.jboss.ws.metadata.wsse.TimestampVerification;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecurityDecoder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SecurityDecoder.class);
    private Element headerElement;
    private Calendar now = null;
    private SecurityHeader header;
    private Document message;
    private NonceFactory nonceFactory;
    private SecurityStore store;
    private TimestampVerification timestampVerification;
    private Authenticate authenticate;
    private HashSet<String> signedIds = new HashSet();
    private HashSet<String> encryptedIds = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityDecoder(SecurityStore store, NonceFactory nonceFactory, TimestampVerification timestampVerification, Authenticate authenticate) {
        ClassLoader origCL = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(Init.class.getClassLoader());
            Init.init();
        }
        finally {
            SecurityActions.setContextClassLoader(origCL);
        }
        this.store = store;
        this.nonceFactory = nonceFactory;
        this.timestampVerification = timestampVerification;
        this.authenticate = authenticate;
    }

    public SecurityDecoder(SecurityStore store, Calendar now, NonceFactory nonceFactory, TimestampVerification timestampVerification, Authenticate authenticate) {
        this(store, nonceFactory, timestampVerification, authenticate);
        this.now = now;
    }

    private Element getHeader(Document message) throws WSSecurityException {
        Element header = Util.findElement(message.getDocumentElement(), "Security", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (header == null) {
            throw new WSSecurityException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"EXPECTED_SECURITY_HEADER", (Object[])new Object[0]));
        }
        return header;
    }

    private void detachHeader() {
        this.headerElement.getParentNode().removeChild(this.headerElement);
    }

    private void decode() throws WSSecurityException {
        Timestamp timestamp = this.header.getTimestamp();
        if (timestamp != null) {
            TimestampVerificationOperation operation = this.now == null ? new TimestampVerificationOperation(this.timestampVerification) : new TimestampVerificationOperation(this.now);
            operation.process(this.message, timestamp);
        }
        if (this.authenticate == null || this.authenticate.isUsernameAuth()) {
            for (Token token : this.header.getTokens()) {
                if (!(token instanceof UsernameToken)) continue;
                new ReceiveUsernameOperation(this.header, this.store, this.nonceFactory != null ? this.nonceFactory.getStore() : null).process(this.message, token);
            }
        }
        this.signedIds.clear();
        this.encryptedIds.clear();
        SignatureVerificationOperation signatureVerifier = new SignatureVerificationOperation(this.header, this.store);
        DecryptionOperation decrypter = new DecryptionOperation(this.header, this.store);
        for (SecurityProcess process : this.header.getSecurityProcesses()) {
            Collection<String> ids;
            if (process instanceof Signature) {
                Signature signature = (Signature)process;
                Collection<String> ids2 = signatureVerifier.process(this.message, signature);
                if (ids2 != null) {
                    this.signedIds.addAll(ids2);
                }
                if (this.authenticate == null || !this.authenticate.isSignatureCertAuth()) continue;
                new ReceiveX509Certificate(this.authenticate.getSignatureCertAuth().getCertificatePrincipal()).process(this.message, signature.getSecurityToken());
                continue;
            }
            if (!(process instanceof EncryptedKey) || (ids = decrypter.process(this.message, process)) == null) continue;
            this.encryptedIds.addAll(ids);
        }
    }

    public void verify(List<RequireOperation> requireOperations) throws WSSecurityException {
        if (requireOperations == null) {
            return;
        }
        for (RequireOperation op : requireOperations) {
            HashSet<String> processedIds = null;
            if (op instanceof RequireSignatureOperation) {
                processedIds = this.signedIds;
            } else if (op instanceof RequireEncryptionOperation) {
                processedIds = this.encryptedIds;
            }
            op.process(this.message, this.header, processedIds);
        }
    }

    public void decode(Document message) throws WSSecurityException {
        this.decode(message, this.getHeader(message));
    }

    public void decode(Document message, Element headerElement) throws WSSecurityException {
        this.headerElement = headerElement;
        this.header = new SecurityHeader(this.headerElement, this.store);
        this.message = message;
        this.decode();
    }

    public void complete() {
        this.detachHeader();
    }
}

