/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client.serviceref;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxrpc.client.ServiceExt;
import org.jboss.ws.core.jaxrpc.client.ServiceImpl;
import org.jboss.ws.core.jaxrpc.client.ServiceProxy;
import org.jboss.ws.core.jaxrpc.client.serviceref.SecurityActions;
import org.jboss.ws.core.server.PortComponentResolver;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.EndpointResolver;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public final class NativeServiceObjectFactoryJAXRPC
implements ObjectFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NativeServiceObjectFactoryJAXRPC.class);
    private static final Logger log = Logger.getLogger(NativeServiceObjectFactoryJAXRPC.class);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            RefAddr pcLinkRef;
            Reference ref = (Reference)obj;
            UnifiedServiceRefMetaData serviceRef = null;
            RefAddr metaRefAddr = ref.get("SERVICE_REF_META_DATA");
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])metaRefAddr.getContent());
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                serviceRef = (UnifiedServiceRefMetaData)ois.readObject();
                ois.close();
            }
            catch (IOException ex) {
                NamingException ne = new NamingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNMARSHALL_SERVICE_REF_META_DATA", (Object[])new Object[0]));
                ne.setRootCause(ex);
                throw ne;
            }
            WSSecurityConfiguration securityConfig = null;
            RefAddr wsseRefAddr = ref.get("SECURITY_CONFIG");
            if (wsseRefAddr != null) {
                bais = new ByteArrayInputStream((byte[])wsseRefAddr.getContent());
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    securityConfig = (WSSecurityConfiguration)ois.readObject();
                    ois.close();
                }
                catch (IOException e) {
                    throw new NamingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNMARSHALL_SECURITY_CONFIG", (Object[])new Object[]{e.toString()}));
                }
            }
            ServiceImpl jaxrpcService = null;
            URL wsdlLocation = serviceRef.getWsdlLocation();
            if (wsdlLocation != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create jaxrpc service from wsdl");
                }
                QName serviceName = serviceRef.getServiceQName();
                JavaWsdlMapping javaWsdlMapping = this.getJavaWsdlMapping(serviceRef);
                jaxrpcService = new ServiceImpl(serviceName, wsdlLocation, javaWsdlMapping, securityConfig, serviceRef);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Create jaxrpc service with no wsdl");
                }
                jaxrpcService = new ServiceImpl(new QName("http://www.jboss.org/jbossws", "AnonymousService"));
            }
            ServiceMetaData serviceMetaData = jaxrpcService.getServiceMetaData();
            if (serviceRef.getCallProperties().size() > 0) {
                Properties callProps = new Properties();
                serviceMetaData.setProperties(callProps);
                for (UnifiedCallPropertyMetaData prop : serviceRef.getCallProperties()) {
                    callProps.setProperty(prop.getPropName(), prop.getPropValue());
                }
            }
            if ((pcLinkRef = ref.get("PORT_COMPONENT_LINK")) != null) {
                String pcLink = (String)pcLinkRef.getContent();
                log.debug((Object)("Resolving port-component-link: " + pcLink));
                String endpointAddress = null;
                try {
                    SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
                    EndpointRegistry epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
                    Endpoint endpoint = epRegistry.resolve((EndpointResolver)new PortComponentResolver(pcLink));
                    if (endpoint == null) {
                        throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_RESOLVE_PORT_COMPONENT_LINK", (Object[])new Object[]{pcLink}));
                    }
                    ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
                    endpointAddress = sepMetaData.getEndpointAddress();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (endpointAddress == null) {
                    String servletPath = (String)ref.get("PORT_COMPONENT_LINK_SERVLET").getContent();
                    servletPath = servletPath + "?pcLink=" + URLEncoder.encode(pcLink, "UTF-8");
                    InputStream is = new URL(servletPath).openStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    endpointAddress = br.readLine();
                    br.close();
                    is.close();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved to: " + endpointAddress));
                }
                if (serviceMetaData.getEndpoints().size() == 1) {
                    EndpointMetaData epMetaData = serviceMetaData.getEndpoints().get(0);
                    epMetaData.setEndpointAddress(endpointAddress);
                } else {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_SET_ENDPOINT_ADDRESS", (Object[])new Object[0]));
                }
            }
            this.narrowPortSelection(serviceRef, serviceMetaData);
            ClassLoader contextCL = SecurityActions.getContextClassLoader();
            Class<?> siClass = SecurityActions.loadClass(contextCL, serviceRef.getServiceInterface());
            if (!Service.class.isAssignableFrom(siClass)) {
                throw new JAXRPCException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_IMPLEMENT_SERVICE", (Object[])new Object[]{siClass.getName()}));
            }
            for (UnifiedPortComponentRefMetaData pcr : serviceRef.getPortComponentRefs()) {
                Class<?> seiClass;
                String seiName = pcr.getServiceEndpointInterface();
                if (seiName == null || Remote.class.isAssignableFrom(seiClass = contextCL.loadClass(seiName))) continue;
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_IMPLEMENT_REMOTE", (Object[])new Object[]{seiClass.getName()}));
            }
            this.setupHandlerChain(jaxrpcService);
            ServiceProxy handler = new ServiceProxy(jaxrpcService, siClass);
            return Proxy.newProxyInstance(contextCL, new Class[]{siClass, ServiceExt.class}, (InvocationHandler)handler);
        }
        catch (Exception ex) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_CREATE_SERVICE", (Object[])new Object[0]), (Throwable)ex);
            throw ex;
        }
    }

    protected void narrowPortSelection(UnifiedServiceRefMetaData serviceRef, ServiceMetaData serviceMetaData) {
        if (serviceMetaData.getEndpoints().size() > 1) {
            HashMap<String, UnifiedPortComponentRefMetaData> pcrefs = new HashMap<String, UnifiedPortComponentRefMetaData>();
            for (UnifiedPortComponentRefMetaData pcref : serviceRef.getPortComponentRefs()) {
                String seiName = pcref.getServiceEndpointInterface();
                if (pcrefs.get(seiName) != null) {
                    throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_ALLOWED_TO_USE", (Object[])new Object[]{seiName}));
                }
                pcrefs.put(seiName, pcref);
            }
            for (String sei : pcrefs.keySet()) {
                ArrayList<QName> narrowedEndpoints = new ArrayList<QName>();
                UnifiedPortComponentRefMetaData pcref = (UnifiedPortComponentRefMetaData)pcrefs.get(sei);
                if (pcref.getServiceEndpointInterface() != null && pcref.getPortQName() != null) {
                    ArrayList<QName> pcRef2EndpointMapping = new ArrayList<QName>();
                    for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                        if (!pcref.getServiceEndpointInterface().equals(epMetaData.getServiceEndpointInterfaceName())) continue;
                        pcRef2EndpointMapping.add(epMetaData.getPortName());
                    }
                    for (QName q : pcRef2EndpointMapping) {
                        EndpointMetaData mappedEndpoint = serviceMetaData.getEndpoint(q);
                        if (pcref.getPortQName().equals(mappedEndpoint.getPortName())) continue;
                        narrowedEndpoints.add(q);
                    }
                    if (pcRef2EndpointMapping.size() > 0 && pcRef2EndpointMapping.size() == narrowedEndpoints.size()) {
                        throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_NARROW_ENDPOINTS", (Object[])new Object[0]));
                    }
                    for (QName q : narrowedEndpoints) {
                        EndpointMetaData removed = serviceMetaData.removeEndpoint(q);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Narrowed endpoint " + q + "(" + removed + ")"));
                    }
                    continue;
                }
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_NARROW_PORT_SELECTION", (Object[])new Object[]{pcref}));
            }
        }
    }

    private void setupHandlerChain(ServiceImpl jaxrpcService) throws Exception {
        List<EndpointMetaData> endpoints = jaxrpcService.getServiceMetaData().getEndpoints();
        for (EndpointMetaData epMetaData : endpoints) {
            jaxrpcService.setupHandlerChain(epMetaData);
        }
    }

    private JavaWsdlMapping getJavaWsdlMapping(UnifiedServiceRefMetaData serviceRef) {
        JavaWsdlMapping javaWsdlMapping = null;
        if (serviceRef.getMappingFile() != null) {
            String mappingFile = serviceRef.getMappingFile();
            try {
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                URL mappingURL = serviceRef.getVfsRoot().findChild(mappingFile).toURL();
                javaWsdlMapping = mappingFactory.parse(mappingURL);
            }
            catch (Exception e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNMARSHALL_JAXRPC_MAPPING_FILE", (Object[])new Object[]{mappingFile}), e);
            }
        }
        return javaWsdlMapping;
    }
}

