/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class SecurityRoleRemove
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    static final SecurityRoleRemove INSTANCE = new SecurityRoleRemove();

    SecurityRoleRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        HornetQServer server = SecurityRoleRemove.getServer(context, operation);
        if (server != null) {
            String match = address.getElement(address.size() - 2).getValue();
            String roleName = address.getLastElement().getValue();
            HashSet<Role> newRoles = new HashSet<Role>();
            Set roles = (Set)server.getSecurityRepository().getMatch(match);
            for (Role role : roles) {
                if (roleName.equals(role.getName())) continue;
                newRoles.add(role);
            }
            server.getSecurityRepository().addMatch(match, newRoles);
        }
    }

    static HornetQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(hqServiceName);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getSecurityRoleRemove(locale);
    }
}

