/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.GroupBindingService;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

class HornetQServerRemove
implements OperationStepHandler {
    static final HornetQServerRemove INSTANCE = new HornetQServerRemove();

    HornetQServerRemove() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String serverName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                HornetQServerRemove.removeHornetQServer(serverName, context, resource);
                if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                    // empty if block
                }
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }

    static void removeHornetQServer(String serverName, OperationContext context, Resource resource) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(serverName);
        for (Resource.ResourceEntry jmsQueue : resource.getChildren("jms-queue")) {
            context.removeService(JMSServices.getJmsQueueBaseServiceName(hqServiceName).append(new String[]{jmsQueue.getName()}));
        }
        for (Resource.ResourceEntry jmsTopic : resource.getChildren("jms-topic")) {
            context.removeService(JMSServices.getJmsTopicBaseServiceName(hqServiceName).append(new String[]{jmsTopic.getName()}));
        }
        for (Resource.ResourceEntry cf : resource.getChildren("connection-factory")) {
            context.removeService(JMSServices.getConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{cf.getName()}));
        }
        for (Resource.ResourceEntry pcf : resource.getChildren("pooled-connection-factory")) {
            context.removeService(hqServiceName.append(JMSServices.getPooledConnectionFactoryBaseServiceName(hqServiceName)).append(new String[]{pcf.getName()}));
        }
        for (Resource.ResourceEntry queue : resource.getChildren("queue")) {
            context.removeService(hqServiceName.append(MessagingServices.getQueueBaseServiceName(hqServiceName)).append(new String[]{queue.getName()}));
        }
        context.removeService(JMSServices.getJmsManagerBaseServiceName(hqServiceName));
        context.removeService(MessagingServices.getHornetQServiceName(serverName));
        for (Resource.ResourceEntry broadcastGroup : resource.getChildren("broadcast-group")) {
            context.removeService(GroupBindingService.getBroadcastBaseServiceName(hqServiceName).append(new String[]{broadcastGroup.getName()}));
        }
        for (Resource.ResourceEntry divertGroup : resource.getChildren("discovery-group")) {
            context.removeService(GroupBindingService.getDiscoveryBaseServiceName(hqServiceName).append(new String[]{divertGroup.getName()}));
        }
        context.removeService(hqServiceName.append(new String[]{"paths"}).append(new String[]{"bindings"}));
        context.removeService(hqServiceName.append(new String[]{"paths"}).append(new String[]{"journal"}));
        context.removeService(hqServiceName.append(new String[]{"paths"}).append(new String[]{"largemessages"}));
        context.removeService(hqServiceName.append(new String[]{"paths"}).append(new String[]{"paging"}));
    }
}

