/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.dmr.ModelNode;

public class DiscoveryGroupWriteAttributeHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    public static final DiscoveryGroupWriteAttributeHandler INSTANCE = new DiscoveryGroupWriteAttributeHandler();
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();

    private DiscoveryGroupWriteAttributeHandler() {
        for (AttributeDefinition attr : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
            this.attributes.put(attr.getName(), attr);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry, boolean registerRuntimeOnly) {
        EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        for (AttributeDefinition attr : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
            if (!registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
        }
    }

    protected void modelChanged(OperationContext context, ModelNode operation, final String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource;
                AttributeDefinition attr = (AttributeDefinition)DiscoveryGroupWriteAttributeHandler.this.attributes.get(attributeName);
                if (attr.hasAlternative((resource = context.readResource(PathAddress.EMPTY_ADDRESS)).getModel())) {
                    context.setRollbackOnly();
                    throw new OperationFailedException(new ModelNode().set(MessagingMessages.MESSAGES.altAttributeAlreadyDefined(attributeName)));
                }
            }
        }, OperationContext.Stage.VERIFY);
        context.reloadRequired();
        if (context.completeStep() != OperationContext.ResultAction.KEEP) {
            context.revertReloadRequired();
        }
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateParameter(name, value);
    }
}

