/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.Locale;
import org.hornetq.api.core.management.BroadcastGroupControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.AbstractHornetQComponentControlHandler;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BroadcastGroupControlHandler
extends AbstractHornetQComponentControlHandler<BroadcastGroupControl> {
    public static final BroadcastGroupControlHandler INSTANCE = new BroadcastGroupControlHandler();
    public static final String GET_CONNECTOR_PAIRS_AS_JSON = "get-connector-pairs-as-json";

    private BroadcastGroupControlHandler() {
    }

    @Override
    public void register(ManagementResourceRegistration registry) {
        super.register(registry);
        registry.registerOperationHandler(GET_CONNECTOR_PAIRS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, BroadcastGroupControlHandler.GET_CONNECTOR_PAIRS_AS_JSON, "broadcast-group", ModelType.STRING, false);
            }
        }, EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY));
    }

    @Override
    protected BroadcastGroupControl getHornetQComponentControl(HornetQServer hqServer, PathAddress address) {
        String resourceName = address.getLastElement().getValue();
        return (BroadcastGroupControl)BroadcastGroupControl.class.cast(hqServer.getManagementService().getResource("core.broadcastgroup." + resourceName));
    }

    @Override
    protected String getDescriptionPrefix() {
        return "broadcast-group";
    }

    @Override
    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if (GET_CONNECTOR_PAIRS_AS_JSON.equals(operationName)) {
            BroadcastGroupControl control = (BroadcastGroupControl)this.getHornetQComponentControl(context, operation, false);
            try {
                context.getResult().set(control.getConnectorPairsAsJSON());
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            this.unsupportedOperation(operationName);
        }
        return null;
    }
}

