/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;
import org.apache.ws.scout.registry.ConnectionImpl;

public class ConnectionFactoryImpl
extends ConnectionFactory
implements Serializable {
    private static final long serialVersionUID = -6902106826496922256L;
    public static final String QUERYMANAGER_PROPERTY = "javax.xml.registry.queryManagerURL";
    public static final String LIFECYCLEMANAGER_PROPERTY = "javax.xml.registry.lifeCycleManagerURL";
    public static final String SECURITYMANAGER_PROPERTY = "javax.xml.registry.securityManagerURL";
    public static final String SEMANTICEQUIVALENCES_PROPERTY = "javax.xml.registry.semanticEquivalences";
    public static final String POSTALADDRESSSCHEME_PROPERTY = "javax.xml.registry.postalAddressScheme";
    public static final String AUTHENTICATIONMETHOD_PROPERTY = "javax.xml.registry.security.authenticationMethod";
    public static final String MAXROWS_PROPERTY = "javax.xml.registry.uddi.maxRows";
    public static final String ADMIN_ENDPOINT_PROPERTY = "scout.proxy.adminURL";
    public static final String TRANSPORT_CLASS_PROPERTY = "scout.proxy.transportClass";
    public static final String SECURITY_PROVIDER_PROPERTY = "scout.proxy.securityProvider";
    public static final String PROTOCOL_HANDLER_PROPERTY = "scout.proxy.protocolHandler";
    public static final String UDDI_VERSION_PROPERTY = "scout.proxy.uddiVersion";
    public static final String UDDI_NAMESPACE_PROPERTY = "scout.proxy.uddiNamespace";
    private Properties properties = new Properties();

    public Connection createConnection() throws JAXRException {
        String queryManagerURL = this.properties.getProperty(QUERYMANAGER_PROPERTY);
        if (queryManagerURL == null) {
            throw new InvalidRequestException("Missing required property javax.xml.registry.queryManagerURL");
        }
        return new ConnectionImpl(this.properties);
    }

    public FederatedConnection createFederatedConnection(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException("FederatedConnections are not supported in this release");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        this.properties.putAll((Map<?, ?>)properties);
    }

    public static ConnectionFactory newInstance() {
        return new ConnectionFactoryImpl();
    }
}

