/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.jaxr.JAXRConstants;
import org.jboss.as.jaxr.extension.JAXRPropertyWrite;
import org.jboss.as.jaxr.extension.JAXRWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JAXRSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        JAXRConstants.Namespace readerNS = JAXRConstants.Namespace.forUri(reader.getNamespaceURI());
        switch (readerNS) {
            case JAXR_1_0: {
                this.readElement1_0(reader, operations);
                break;
            }
            case JAXR_1_1: {
                this.readElement1_1(reader, operations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readElement1_0(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "jaxr");
        address.protect();
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(address);
        operations.add(addOp);
        List<ModelNode> propertiesOps = null;
        while (reader.hasNext() && reader.nextTag() != 2) {
            block0 : switch (JAXRConstants.Namespace.forUri(reader.getNamespaceURI())) {
                case JAXR_1_0: {
                    JAXRConstants.Element element = JAXRConstants.Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTION_FACTORY: {
                            this.parseBinding1_0(reader, addOp);
                            break block0;
                        }
                        case JUDDI_SERVER: {
                            propertiesOps = this.parseJuddiServer(reader, address);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        if (propertiesOps != null) {
            operations.addAll(propertiesOps);
        }
    }

    private void readElement1_1(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "jaxr");
        address.protect();
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(address);
        operations.add(addOp);
        List<ModelNode> propertiesOps = null;
        while (reader.hasNext() && reader.nextTag() != 2) {
            block0 : switch (JAXRConstants.Namespace.forUri(reader.getNamespaceURI())) {
                case JAXR_1_1: {
                    JAXRConstants.Element element = JAXRConstants.Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTION_FACTORY: {
                            this.parseBinding1_1(reader, addOp);
                            break block0;
                        }
                        case PROPERTIES: {
                            propertiesOps = this.parseProperties(reader, address);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        if (propertiesOps != null) {
            operations.addAll(propertiesOps);
        }
    }

    private void parseBinding1_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        String jndiName = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            JAXRConstants.Attribute attribute = JAXRConstants.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case JNDI_NAME: {
                    jndiName = attrValue;
                    JAXRWriteAttributeHandler.CONNECTION_FACTORY_ATTRIBUTE.parseAndSetParameter(jndiName, addOp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (jndiName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(JAXRConstants.Attribute.JNDI_NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseBinding1_1(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        String jndiName = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            JAXRConstants.Attribute attribute = JAXRConstants.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case JNDI_NAME: {
                    jndiName = attrValue;
                    JAXRWriteAttributeHandler.CONNECTION_FACTORY_ATTRIBUTE.parseAndSetParameter(jndiName, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                case CLASS: {
                    JAXRWriteAttributeHandler.CONNECTION_FACTORY_IMPL_ATTRIBUTE.parseAndSetParameter(jndiName, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (jndiName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(JAXRConstants.Attribute.JNDI_NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private List<ModelNode> parseProperties(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            block0 : switch (JAXRConstants.Namespace.forUri(reader.getNamespaceURI())) {
                case JAXR_1_1: {
                    JAXRConstants.Element element = JAXRConstants.Element.forName(reader.getLocalName());
                    switch (element) {
                        case PROPERTY: {
                            ModelNode propNode = this.parseProperty(reader, address);
                            result.add(propNode);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        return result;
    }

    private ModelNode parseProperty(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            JAXRConstants.Attribute attribute = JAXRConstants.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = attrValue;
                    continue block4;
                }
                case VALUE: {
                    value = attrValue;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(JAXRConstants.Attribute.NAME));
        }
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(JAXRConstants.Attribute.VALUE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode propNode = new ModelNode();
        propNode.get("operation").set("add");
        propNode.get("address").set(address).add("property", name);
        propNode.get("value").set(value);
        return propNode;
    }

    private List<ModelNode> parseJuddiServer(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        EnumSet<JAXRConstants.Attribute> required = EnumSet.of(JAXRConstants.Attribute.PUBLISH_URL, JAXRConstants.Attribute.QUERY_URL);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            JAXRConstants.Attribute attribute = JAXRConstants.Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PUBLISH_URL: {
                    ModelNode propOp = new ModelNode();
                    propOp.get("operation").set("add");
                    propOp.get("address").set(address).add("property", "javax.xml.registry.lifeCycleManagerURL");
                    JAXRPropertyWrite.VALUE.parseAndSetParameter(attrValue, propOp, (XMLStreamReader)reader);
                    result.add(propOp);
                    continue block4;
                }
                case QUERY_URL: {
                    ModelNode propOp = new ModelNode();
                    propOp.get("operation").set("add");
                    propOp.get("address").set(address).add("property", "javax.xml.registry.queryManagerURL");
                    JAXRPropertyWrite.VALUE.parseAndSetParameter(attrValue, propOp, (XMLStreamReader)reader);
                    result.add(propOp);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return result;
    }
}

