/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jaxr.JAXRConfiguration;
import org.jboss.as.jaxr.JAXRConstants;
import org.jboss.as.jaxr.extension.JAXRPropertyAdd;
import org.jboss.as.jaxr.extension.JAXRPropertyRemove;
import org.jboss.as.jaxr.extension.JAXRPropertyWrite;
import org.jboss.as.jaxr.extension.JAXRSubsystemParser;
import org.jboss.as.jaxr.extension.JAXRSubsystemRootResource;
import org.jboss.as.jaxr.extension.JAXRSubsystemWriter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JAXRSubsystemExtension
implements Extension {
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;
    private final JAXRSubsystemParser parser = new JAXRSubsystemParser();
    private final JAXRConfiguration config = new JAXRConfiguration();
    static final DescriptionProvider PROPERTY_DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = JAXRConfiguration.getResourceBundle(locale);
            node.get("description").set(resbundle.getString("jaxr.property"));
            node.get(new String[]{"attributes", "value", "description"}).set(resbundle.getString("jaxr.property.value"));
            node.get(new String[]{"attributes", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "value", "required"}).set(true);
            return node;
        }
    };

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping("jaxr", JAXRConstants.Namespace.JAXR_1_1.getUriString(), (XMLElementReader)this.parser);
        context.setSubsystemXmlMapping("jaxr", JAXRConstants.Namespace.JAXR_1_0.getUriString(), (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem("jaxr", 1, 1);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new JAXRSubsystemRootResource(this.config));
        registration.registerOperationHandler("describe", (OperationStepHandler)SubsystemDescribeHandler.INSTANCE, (DescriptionProvider)SubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration properties = registration.registerSubModel(PathElement.pathElement((String)"property"), PROPERTY_DESCRIPTION);
        properties.registerOperationHandler("add", (OperationStepHandler)new JAXRPropertyAdd(this.config), JAXRPropertyAdd.DESCRIPTION, false);
        properties.registerOperationHandler("remove", (OperationStepHandler)new JAXRPropertyRemove(this.config), JAXRPropertyRemove.DESCRIPTION, false);
        properties.registerReadWriteAttribute("value", null, (OperationStepHandler)new JAXRPropertyWrite(this.config), AttributeAccess.Storage.CONFIGURATION);
        subsystem.registerXMLElementWriter((XMLElementWriter)JAXRSubsystemWriter.INSTANCE);
    }

    private static class SubsystemDescribeHandler
    extends GenericSubsystemDescribeHandler {
        static final SubsystemDescribeHandler INSTANCE = new SubsystemDescribeHandler();

        private SubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.execute(context, operation);
            context.completeStep();
        }
    }
}

