/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.process;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.SAMLHandlerChainProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderSAMLResponseProcessor
extends ServiceProviderBaseProcessor {
    private boolean validateSignature = false;

    public ServiceProviderSAMLResponseProcessor(boolean postBinding, String serviceURL) {
        super(postBinding, serviceURL);
    }

    public void setValidateSignature(boolean validateSignature) {
        this.validateSignature = validateSignature;
    }

    public SAML2HandlerResponse process(String samlResponse, HTTPContext httpContext, Set<SAML2Handler> handlers, Lock chainLock) throws ProcessingException, IOException, ParsingException, ConfigurationException {
        SAML2Response saml2Response = new SAML2Response();
        SAMLDocumentHolder documentHolder = null;
        SAML2Object samlObject = null;
        if (this.postBinding) {
            InputStream is = PostBindingUtil.base64DecodeAsStream(samlResponse);
            samlObject = saml2Response.getSAML2ObjectFromStream(is);
            documentHolder = saml2Response.getSamlDocumentHolder();
        } else {
            InputStream base64DecodedResponse = RedirectBindingUtil.base64DeflateDecode(samlResponse);
            samlObject = saml2Response.getSAML2ObjectFromStream(base64DecodedResponse);
            documentHolder = saml2Response.getSamlDocumentHolder();
        }
        if (this.validateSignature) {
            try {
                if (!this.verifySignature(documentHolder)) {
                    throw new ProcessingException("PL00009: Invalid Digital Signature:Signature Validation failed");
                }
            }
            catch (IssuerNotTrustedException e) {
                throw new ProcessingException(e);
            }
        }
        SAML2HandlerRequest saml2HandlerRequest = this.getSAML2HandlerRequest(documentHolder, httpContext);
        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
        SAMLHandlerChainProcessor chainProcessor = new SAMLHandlerChainProcessor(handlers);
        if (this.spConfiguration != null) {
            HashMap<String, Object> requestOptions = new HashMap<String, Object>();
            requestOptions.put("CONFIGURATION", this.spConfiguration);
            if (this.keyManager != null) {
                String idpKey;
                String remoteHost = httpContext.getRequest().getRemoteAddr();
                if (this.trace) {
                    log.trace((Object)("ServiceProviderSAMLResponseProcessor::Remote Host=" + remoteHost));
                }
                if (StringUtil.isNullOrEmpty(idpKey = (String)this.keyManager.getAdditionalOption("idp.key"))) {
                    idpKey = remoteHost;
                }
                PublicKey validatingKey = CoreConfigUtil.getValidatingKey(this.keyManager, idpKey);
                requestOptions.put("SENDER_PUBLIC_KEY", validatingKey);
                requestOptions.put("DECRYPTING_KEY", this.keyManager.getSigningKey());
            }
            saml2HandlerRequest.setOptions(requestOptions);
        }
        chainProcessor.callHandlerChain(samlObject, saml2HandlerRequest, saml2HandlerResponse, httpContext, chainLock);
        return saml2HandlerResponse;
    }

    private boolean verifySignature(SAMLDocumentHolder samlDocumentHolder) throws IssuerNotTrustedException {
        URL issuerURL;
        if (this.keyManager == null) {
            throw new IllegalStateException("PL00078: Null Parameter:Key Manager");
        }
        Document samlResponse = samlDocumentHolder.getSamlDocument();
        StatusResponseType response = (StatusResponseType)samlDocumentHolder.getSamlObject();
        String issuerID = response.getIssuer().getValue();
        if (issuerID == null) {
            throw new IssuerNotTrustedException("PL00092: Null Value:Issue missing");
        }
        try {
            issuerURL = new URL(issuerID);
        }
        catch (MalformedURLException e1) {
            throw new IssuerNotTrustedException(e1);
        }
        try {
            PublicKey publicKey = this.keyManager.getValidatingKey(issuerURL.getHost());
            if (this.trace) {
                log.trace((Object)"Going to verify signature in the saml response from IDP");
            }
            boolean sigResult = XMLSignatureUtil.validate(samlResponse, publicKey);
            if (this.trace) {
                log.trace((Object)("Signature verification=" + sigResult));
            }
            return sigResult;
        }
        catch (TrustKeyConfigurationException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (TrustKeyProcessingException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (MarshalException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (XMLSignatureException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        return false;
    }
}

