/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.CommonIronJacamarParser;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.util.ParserException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ResourceAdapterParser
extends CommonIronJacamarParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    public void parse(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws Exception {
        int iterate;
        Object adapters = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case RESOURCE_ADAPTERS: {
                        this.parseResourceAdapters(reader, list, parentAddress);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void parseResourceAdapters(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.RESOURCE_ADAPTERS) {
                        return;
                    }
                    if (ResourceAdapters.Tag.forName((String)reader.getLocalName()) != ResourceAdapters.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ResourceAdapters.Tag.forName((String)reader.getLocalName())) {
                        case RESOURCE_ADAPTER: {
                            this.parseResourceAdapter(reader, list, parentAddress);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private void parseResourceAdapter(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentAddress) throws XMLStreamException, ParserException, ValidateException {
        ModelNode raAddress = parentAddress.clone();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String archiveName = null;
        HashMap<String, ModelNode> configPropertiesOperations = new HashMap<String, ModelNode>();
        HashMap<String, ModelNode> connectionDefinitionsOperations = new HashMap<String, ModelNode>();
        HashMap<String, HashMap<String, ModelNode>> cfConfigPropertiesOperations = new HashMap<String, HashMap<String, ModelNode>>();
        HashMap<String, ModelNode> adminObjectsOperations = new HashMap<String, ModelNode>();
        HashMap<String, HashMap<String, ModelNode>> aoConfigPropertiesOperations = new HashMap<String, HashMap<String, ModelNode>>();
        boolean archiveMatched = false;
        boolean txSupportMatched = false;
        boolean isXa = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ResourceAdapters.Tag.forName((String)reader.getLocalName()) == ResourceAdapters.Tag.RESOURCE_ADAPTER) {
                        if (archiveName != null) {
                            ModelNode configEnv;
                            ModelNode env;
                            Integer identifier = ConnectorServices.getResourceIdentifier(archiveName);
                            if (identifier != null && identifier != 0) {
                                archiveName = archiveName + "->" + identifier;
                            }
                            raAddress.add("resource-adapter", archiveName);
                            raAddress.protect();
                            operation.get("address").set(raAddress);
                            list.add(operation);
                            for (Map.Entry<String, ModelNode> entry : configPropertiesOperations.entrySet()) {
                                env = raAddress.clone();
                                env.add(Constants.CONFIG_PROPERTIES.getName(), entry.getKey());
                                env.protect();
                                entry.getValue().get("address").set(env);
                                list.add(entry.getValue());
                            }
                            for (Map.Entry<String, ModelNode> entry : connectionDefinitionsOperations.entrySet()) {
                                env = raAddress.clone();
                                env.add("connection-definitions", entry.getKey());
                                env.protect();
                                entry.getValue().get("address").set(env);
                                list.add(entry.getValue());
                                HashMap<String, ModelNode> properties = cfConfigPropertiesOperations.get(entry.getKey());
                                if (properties == null) continue;
                                for (Map.Entry<String, ModelNode> configEntry : properties.entrySet()) {
                                    configEnv = env.clone();
                                    configEnv.add(Constants.CONFIG_PROPERTIES.getName(), configEntry.getKey());
                                    configEnv.protect();
                                    configEntry.getValue().get("address").set(configEnv);
                                    list.add(configEntry.getValue());
                                }
                            }
                            for (Map.Entry<String, ModelNode> entry : adminObjectsOperations.entrySet()) {
                                env = raAddress.clone();
                                env.add("admin-objects", entry.getKey());
                                env.protect();
                                entry.getValue().get("address").set(env);
                                list.add(entry.getValue());
                                HashMap<String, ModelNode> aoProperties = aoConfigPropertiesOperations.get(entry.getKey());
                                if (aoProperties == null) continue;
                                for (Map.Entry<String, ModelNode> configEntry : aoProperties.entrySet()) {
                                    configEnv = env.clone();
                                    configEnv.add(Constants.CONFIG_PROPERTIES.getName(), configEntry.getKey());
                                    configEnv.protect();
                                    configEntry.getValue().get("address").set(configEnv);
                                    list.add(configEntry.getValue());
                                }
                            }
                            return;
                        }
                        throw new ParserException(bundle.requiredElementMissing(Constants.ARCHIVE.getName(), "resource-adapter"));
                    }
                    if (ResourceAdapter.Tag.forName((String)reader.getLocalName()) != ResourceAdapter.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (ResourceAdapter.Tag.forName((String)reader.getLocalName())) {
                        case ADMIN_OBJECTS: 
                        case CONNECTION_DEFINITIONS: 
                        case BEAN_VALIDATION_GROUPS: {
                            break block0;
                        }
                        case ADMIN_OBJECT: {
                            this.parseAdminObjects(reader, adminObjectsOperations, aoConfigPropertiesOperations);
                            break block0;
                        }
                        case CONNECTION_DEFINITION: {
                            this.parseConnectionDefinitions(reader, connectionDefinitionsOperations, cfConfigPropertiesOperations, isXa);
                            break block0;
                        }
                        case BEAN_VALIDATION_GROUP: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            operation.get(Constants.BEANVALIDATIONGROUPS.getName()).add(Constants.BEANVALIDATIONGROUP.parse(value, (XMLStreamReader)reader));
                            break block0;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.BOOTSTRAPCONTEXT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            this.parseConfigProperties(reader, configPropertiesOperations);
                            break block0;
                        }
                        case TRANSACTION_SUPPORT: {
                            if (txSupportMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.TRANSACTIONSUPPORT.getXmlName()));
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.TRANSACTIONSUPPORT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                            isXa = value != null && TransactionSupportEnum.valueOf((String)value) == TransactionSupportEnum.XATransaction;
                            txSupportMatched = true;
                            break block0;
                        }
                        case ARCHIVE: {
                            if (archiveMatched) {
                                throw new ParserException(bundle.unexpectedElement(Constants.ARCHIVE.getXmlName()));
                            }
                            archiveName = this.rawElementText((XMLStreamReader)reader);
                            Constants.ARCHIVE.parseAndSetParameter(archiveName, operation, (XMLStreamReader)reader);
                            archiveMatched = true;
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        RESOURCE_ADAPTERS("resource-adapters");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

