/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.metadata.deployment.InactiveResourceAdapterDeploymentService;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableAdminObject;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableConnDef;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.util.RaServicesFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class RaOperationUtil {
    public static ModifiableResourceAdapter buildResourceAdaptersObject(OperationContext context, ModelNode operation) throws OperationFailedException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        ArrayList<CommonConnDef> connectionDefinitions = new ArrayList<CommonConnDef>(0);
        ArrayList<CommonAdminObject> adminObjects = new ArrayList<CommonAdminObject>(0);
        String archive = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.ARCHIVE.getName(), null);
        TransactionSupportEnum transactionSupport = operation.hasDefined(Constants.TRANSACTIONSUPPORT.getName()) ? TransactionSupportEnum.valueOf((String)operation.get(Constants.TRANSACTIONSUPPORT.getName()).asString()) : null;
        String bootstrapContext = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.BOOTSTRAPCONTEXT.getName(), null);
        ArrayList<String> beanValidationGroups = null;
        if (operation.hasDefined(Constants.BEANVALIDATIONGROUPS.getName())) {
            beanValidationGroups = new ArrayList<String>(operation.get(Constants.BEANVALIDATIONGROUPS.getName()).asList().size());
            for (ModelNode beanValidation : operation.get(Constants.BEANVALIDATIONGROUPS.getName()).asList()) {
                beanValidationGroups.add(beanValidation.asString());
            }
        }
        ModifiableResourceAdapter ra = new ModifiableResourceAdapter(archive, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext);
        return ra;
    }

    public static ModifiableConnDef buildConnectionDefinitionObject(OperationContext context, ModelNode operation, String poolName, boolean isXa) throws OperationFailedException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.CLASS_NAME.getName(), null);
        String jndiName = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.JNDINAME.getName(), null);
        boolean enabled = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.ENABLED, Defaults.ENABLED);
        boolean useJavaContext = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.USE_JAVA_CONTEXT, Defaults.USE_JAVA_CONTEXT);
        boolean useCcm = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.USE_CCM, Defaults.USE_CCM);
        Integer maxPoolSize = RaOperationUtil.getIntIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE, Defaults.MAX_POOL_SIZE);
        Integer minPoolSize = RaOperationUtil.getIntIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE, Defaults.MIN_POOL_SIZE);
        boolean prefill = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.POOL_PREFILL, Defaults.PREFILL);
        boolean useStrictMin = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN, Defaults.USE_STRICT_MIN);
        FlushStrategy flushStrategy = operation.hasDefined(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()) ? FlushStrategy.forName((String)operation.get(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()).asString()) : Defaults.FLUSH_STRATEGY;
        Boolean isSameRM = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.SAME_RM_OVERRIDE, Defaults.IS_SAME_RM_OVERRIDE);
        Boolean interlivng = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.INTERLEAVING, Defaults.INTERLEAVING);
        Boolean padXid = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.PAD_XID, Defaults.PAD_XID);
        Boolean wrapXaResource = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.WRAP_XA_RESOURCE, Defaults.WRAP_XA_RESOURCE);
        Boolean noTxSeparatePool = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.NOTXSEPARATEPOOL, Defaults.NO_TX_SEPARATE_POOL);
        Integer allocationRetry = RaOperationUtil.getIntIfSetOrGetDefault(context, operation, Constants.ALLOCATION_RETRY, null);
        Long allocationRetryWaitMillis = RaOperationUtil.getLongIfSetOrGetDefault(context, operation, Constants.ALLOCATION_RETRY_WAIT_MILLIS, null);
        Long blockingTimeoutMillis = RaOperationUtil.getLongIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS, null);
        Long idleTimeoutMinutes = RaOperationUtil.getLongIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES, null);
        Integer xaResourceTimeout = RaOperationUtil.getIntIfSetOrGetDefault(context, operation, Constants.XA_RESOURCE_TIMEOUT, null);
        CommonTimeOutImpl timeOut = new CommonTimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        Object pool = null;
        pool = isXa ? new CommonXaPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, isSameRM, interlivng, padXid, wrapXaResource, noTxSeparatePool) : new CommonPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy);
        String securityDomain = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.SECURITY_DOMAIN.getName(), null);
        String securityDomainAndApplication = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.SECURITY_DOMAIN_AND_APPLICATION.getName(), null);
        Boolean application = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.APPLICATION, null);
        CommonSecurityImpl security = null;
        if (securityDomain != null || securityDomainAndApplication != null || application != null) {
            if (application == null) {
                application = Defaults.APPLICATION_MANAGED_SECURITY;
            }
            security = new CommonSecurityImpl(securityDomain, securityDomainAndApplication, application.booleanValue());
        }
        Long backgroundValidationMillis = RaOperationUtil.getLongIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS, null);
        boolean backgroundValidation = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION, Defaults.BACKGROUND_VALIDATION);
        boolean useFastFail = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, org.jboss.as.connector.pool.Constants.USE_FAST_FAIL, Defaults.USE_FAST_FAIl);
        CommonValidationImpl validation = new CommonValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMillis, Boolean.valueOf(useFastFail));
        String recoveryUsername = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.RECOVERY_USERNAME.getName(), null);
        String recoveryPassword = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.RECOVERY_PASSWORD.getName(), null);
        String recoverySecurityDomain = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.RECOVERY_SECURITY_DOMAIN.getName(), null);
        Boolean noRecovery = RaOperationUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.NO_RECOVERY, null);
        Recovery recovery = null;
        if (recoveryUsername != null && recoveryPassword != null || recoverySecurityDomain != null || noRecovery != null) {
            CredentialImpl credential = null;
            if (recoveryUsername != null && recoveryPassword != null || recoverySecurityDomain != null) {
                credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
            }
            Extension recoverPlugin = RaOperationUtil.extractExtension(context, operation, Constants.RECOVERLUGIN_CLASSNAME.getName(), Constants.RECOVERLUGIN_PROPERTIES.getName());
            if (noRecovery == null) {
                noRecovery = Boolean.FALSE;
            }
            recovery = new Recovery((Credential)credential, recoverPlugin, noRecovery);
        }
        ModifiableConnDef connectionDefinition = new ModifiableConnDef(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, (CommonPool)pool, (CommonTimeOut)timeOut, (CommonValidation)validation, (CommonSecurity)security, recovery);
        return connectionDefinition;
    }

    public static ModifiableAdminObject buildAdminObjects(OperationContext operationContext, ModelNode operation, String poolName) throws OperationFailedException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = RaOperationUtil.getResolvedStringIfSetOrGetDefault(operationContext, operation, Constants.CLASS_NAME.getName(), null);
        String jndiName = RaOperationUtil.getResolvedStringIfSetOrGetDefault(operationContext, operation, Constants.JNDINAME.getName(), null);
        boolean enabled = RaOperationUtil.getBooleanIfSetOrGetDefault(operationContext, operation, Constants.ENABLED, Defaults.ENABLED);
        boolean useJavaContext = RaOperationUtil.getBooleanIfSetOrGetDefault(operationContext, operation, Constants.USE_JAVA_CONTEXT, Defaults.USE_JAVA_CONTEXT);
        ModifiableAdminObject adminObject = new ModifiableAdminObject(configProperties, className, jndiName, poolName, enabled, useJavaContext);
        return adminObject;
    }

    private static Long getLongIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key, Long defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key.getName())) {
            if (key.isAllowExpression()) {
                return context.resolveExpressions(dataSourceNode.get(key.getName())).asLong();
            }
            return dataSourceNode.get(key.getName()).asLong();
        }
        return defaultValue;
    }

    private static Integer getIntIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key, Integer defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key.getName())) {
            if (key.isAllowExpression()) {
                return context.resolveExpressions(dataSourceNode.get(key.getName())).asInt();
            }
            return dataSourceNode.get(key.getName()).asInt();
        }
        return defaultValue;
    }

    private static Boolean getBooleanIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key, Boolean defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key.getName())) {
            if (key.isAllowExpression()) {
                return context.resolveExpressions(dataSourceNode.get(key.getName())).asBoolean();
            }
            return dataSourceNode.get(key.getName()).asBoolean();
        }
        return defaultValue;
    }

    private static String getResolvedStringIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, String key, String defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key)) {
            return context.resolveExpressions(dataSourceNode.get(key)).asString();
        }
        return defaultValue;
    }

    private static Extension extractExtension(OperationContext operationContext, ModelNode node, String className, String propertyName) throws ValidateException, OperationFailedException {
        if (node.hasDefined(className)) {
            String exceptionSorterClassName = node.get(className).asString();
            RaOperationUtil.getResolvedStringIfSetOrGetDefault(operationContext, node, className, null);
            HashMap<String, String> exceptionSorterProperty = null;
            if (node.hasDefined(propertyName)) {
                exceptionSorterProperty = new HashMap<String, String>(node.get(propertyName).asList().size());
                for (ModelNode property : node.get(propertyName).asList()) {
                    exceptionSorterProperty.put(property.asProperty().getName(), property.asProperty().getValue().asString());
                }
            }
            return new Extension(exceptionSorterClassName, exceptionSorterProperty);
        }
        return null;
    }

    public static void deactivateIfActive(OperationContext context, String raName) throws OperationFailedException {
        ServiceName raDeploymentServiceName = ConnectorServices.getDeploymentServiceName(raName);
        Integer identifier = 0;
        if (raName.indexOf("->") != -1) {
            identifier = Integer.valueOf(raName.substring(raName.indexOf("->") + 2));
            raName = raName.substring(0, raName.indexOf("->"));
        }
        if (raDeploymentServiceName != null) {
            context.removeService(raDeploymentServiceName);
            ConnectorServices.unregisterDeployment(raName, raDeploymentServiceName);
        }
        ConnectorServices.unregisterResourceIdentifier(raName, identifier);
    }

    public static void activate(OperationContext context, String raName, String rarName) throws OperationFailedException {
        ServiceController inactiveRaController;
        ServiceRegistry registry = context.getServiceRegistry(true);
        if (rarName.contains("->")) {
            rarName = rarName.substring(0, rarName.indexOf("->"));
        }
        if ((inactiveRaController = registry.getService(ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{rarName}))) == null) {
            throw new OperationFailedException("rar not yet deployed");
        }
        InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment inactive = (InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment)inactiveRaController.getValue();
        ServiceController RaxmlController = registry.getService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName}));
        ResourceAdapter raxml = (ResourceAdapter)RaxmlController.getValue();
        RaServicesFactory.createDeploymentService(inactive.getRegistration(), inactive.getConnectorXmlDescriptor(), inactive.getModule(), context.getServiceTarget(), inactive.getDeployment(), inactive.getDeployment(), raxml);
    }
}

