/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class RaAdd
extends AbstractAddStepHandler {
    static final RaAdd INSTANCE = new RaAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : ResourceAdaptersSubsystemProviders.RESOURCEADAPTER_ATTRIBUTE) {
            attribute.validateAndSet(operation, model);
        }
    }

    public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        String archiveName;
        ModelNode address = operation.require("address");
        String name = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        if (name.startsWith(archiveName = model.get(Constants.ARCHIVE.getName()).asString()) && (name.substring(archiveName.length()).contains("->") || name.equals(archiveName))) {
            archiveName = name;
        } else {
            Integer identifier = ConnectorServices.getResourceIdentifier(archiveName);
            if (identifier != null && identifier != 0) {
                archiveName = archiveName + "->" + identifier;
            }
        }
        model.get(Constants.ARCHIVE.getName()).set(archiveName);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModifiableResourceAdapter resourceAdapter = RaOperationUtil.buildResourceAdaptersObject(context, operation);
        ServiceController resourceAdaptersService = context.getServiceRegistry(false).getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
        ServiceController controller = null;
        if (resourceAdaptersService == null) {
            controller = serviceTarget.addService(ConnectorServices.RESOURCEADAPTERS_SERVICE, (Service)new ResourceAdaptersService()).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install();
        }
        ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{name});
        ResourceAdapterService raService = new ResourceAdapterService(resourceAdapter);
        serviceTarget.addService(raServiceName, (Service)raService).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ConnectorServices.RESOURCEADAPTERS_SERVICE, ResourceAdaptersService.ModifiableResourceAdaptors.class, raService.getResourceAdaptersInjector()).addListener((ServiceListener)verificationHandler).install();
    }
}

