/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import java.util.Locale;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertiesService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class ConnectionPropertyAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final ConnectionPropertyAdd INSTANCE = new ConnectionPropertyAdd();

    public ModelNode getModelDescription(Locale locale) {
        return DataSourcesSubsystemProviders.ADD_CONNECTION_PROPERTIES_DESC.getModelDescription(Locale.getDefault());
    }

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        Constants.CONNECTION_PROPERTY_VALUE.validateAndSet(operation, modelNode);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode recoveryEnvModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        ServiceName dataSourceConfigServiceName;
        String configPropertyValue = Constants.CONNECTION_PROPERTY_VALUE.resolveModelAttribute(context, recoveryEnvModel).asString();
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String jndiName = path.getElement(path.size() - 2).getValue();
        String configPropertyName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        ServiceName serviceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName}).append(new String[]{"connection-properties"}).append(new String[]{configPropertyName});
        ServiceName dsServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController dataSourceConfigController = registry.getService(dataSourceConfigServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName}));
        if (dataSourceConfigController == null || !((DataSource)dataSourceConfigController.getValue()).isEnabled().booleanValue()) {
            ServiceTarget serviceTarget = context.getServiceTarget();
            ConnectionPropertiesService service = new ConnectionPropertiesService(configPropertyName, configPropertyValue);
            serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.NEVER).addListener((ServiceListener)verificationHandler).install();
            context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
        } else {
            context.reloadRequired();
        }
    }
}

