/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.ManagementDescriptions;
import org.jboss.as.domain.management.security.RealmRole;
import org.jboss.as.domain.management.security.RealmUser;
import org.jboss.as.domain.management.security.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WhoAmIOperation
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "whoami";
    public static final WhoAmIOperation INSTANCE = new WhoAmIOperation();
    private final ParametersValidator validator = new ParametersValidator();

    private WhoAmIOperation() {
        this.validator.registerValidator("verbose", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        Subject subject = SecurityActions.getSecurityContextSubject();
        if (subject == null) {
            throw new OperationFailedException(new ModelNode().set(DomainManagementMessages.MESSAGES.noSecurityContextEstablished()));
        }
        Set<RealmUser> realmUsers = subject.getPrincipals(RealmUser.class);
        if (realmUsers.size() != 1) {
            throw new OperationFailedException(new ModelNode().set(DomainManagementMessages.MESSAGES.unexpectedNumberOfRealmUsers(realmUsers.size())));
        }
        RealmUser user = realmUsers.iterator().next();
        ModelNode result = context.getResult();
        ModelNode identity = result.get("identity");
        identity.get("username").set(user.getName());
        identity.get("realm").set(user.getRealm());
        if (operation.hasDefined("verbose") && operation.require("verbose").asBoolean()) {
            ModelNode roles = result.get("roles");
            Set<RealmRole> roleSet = subject.getPrincipals(RealmRole.class);
            for (RealmRole current : roleSet) {
                roles.add(current.getName());
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ManagementDescriptions.getWhoamiOperationDescription(locale);
    }
}

