/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.PasswordCredential;
import org.jboss.as.domain.management.security.SubjectCallback;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class JaasCallbackHandler
implements Service<DomainCallbackHandler>,
DomainCallbackHandler {
    public static final String SERVICE_SUFFIX = "jaas";
    private static final Class[] CALLBACKS = new Class[]{AuthorizeCallback.class, RealmCallback.class, NameCallback.class, VerifyPasswordCallback.class, SubjectCallback.class};
    private final String name;

    public JaasCallbackHandler(String name) {
        this.name = name;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback) {
            AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
            String authenticationId = acb.getAuthenticationID();
            String authorizationId = acb.getAuthorizationID();
            acb.setAuthorized(authenticationId.equals(authorizationId));
            return;
        }
        NameCallback nameCallBack = null;
        VerifyPasswordCallback verifyPasswordCallback = null;
        SubjectCallback subjectCallback = null;
        for (Callback current : callbacks) {
            if (current instanceof NameCallback) {
                nameCallBack = (NameCallback)current;
                continue;
            }
            if (current instanceof RealmCallback) continue;
            if (current instanceof VerifyPasswordCallback) {
                verifyPasswordCallback = (VerifyPasswordCallback)current;
                continue;
            }
            if (current instanceof SubjectCallback) {
                subjectCallback = (SubjectCallback)current;
                continue;
            }
            throw new UnsupportedCallbackException(current);
        }
        if (nameCallBack == null) {
            throw DomainManagementMessages.MESSAGES.noUsername();
        }
        final String userName = nameCallBack.getDefaultName();
        if (userName == null || userName.length() == 0) {
            throw DomainManagementMessages.MESSAGES.noUsername();
        }
        if (verifyPasswordCallback == null || verifyPasswordCallback.getPassword() == null) {
            throw DomainManagementMessages.MESSAGES.noPassword();
        }
        final char[] password = verifyPasswordCallback.getPassword().toCharArray();
        try {
            Subject subject = subjectCallback != null && subjectCallback.getSubject() != null ? subjectCallback.getSubject() : new Subject();
            LoginContext ctx = new LoginContext(this.name, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback current : callbacks) {
                        if (current instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)current;
                            ncb.setName(userName);
                            continue;
                        }
                        if (current instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)current;
                            pcb.setPassword(password);
                            continue;
                        }
                        throw new UnsupportedCallbackException(current);
                    }
                }
            });
            ctx.login();
            verifyPasswordCallback.setVerified(true);
            subject.getPrivateCredentials().add(new PasswordCredential(userName, password));
            if (subjectCallback != null) {
                subjectCallback.setSubject(subject);
            }
        }
        catch (LoginException e) {
            verifyPasswordCallback.setVerified(false);
        }
    }

    public Class[] getSupportedCallbacks() {
        return CALLBACKS;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public DomainCallbackHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

